/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProductPageRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, DeleteProductPageRequest> {
    private static final SdkField<String> PORTAL_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PortalProductId").getter(DeleteProductPageRequest.getter(DeleteProductPageRequest::portalProductId)).setter(DeleteProductPageRequest.setter(Builder::portalProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalProductId").build()}).build();
    private static final SdkField<String> PRODUCT_PAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductPageId").getter(DeleteProductPageRequest.getter(DeleteProductPageRequest::productPageId)).setter(DeleteProductPageRequest.setter(Builder::productPageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("productPageId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_PRODUCT_ID_FIELD, PRODUCT_PAGE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteProductPageRequest.memberNameToFieldInitializer();
    private final String portalProductId;
    private final String productPageId;

    private DeleteProductPageRequest(BuilderImpl builder) {
        super(builder);
        this.portalProductId = builder.portalProductId;
        this.productPageId = builder.productPageId;
    }

    public final String portalProductId() {
        return this.portalProductId;
    }

    public final String productPageId() {
        return this.productPageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portalProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productPageId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProductPageRequest)) {
            return false;
        }
        DeleteProductPageRequest other = (DeleteProductPageRequest)((Object)obj);
        return Objects.equals(this.portalProductId(), other.portalProductId()) && Objects.equals(this.productPageId(), other.productPageId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteProductPageRequest").add("PortalProductId", (Object)this.portalProductId()).add("ProductPageId", (Object)this.productPageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortalProductId": {
                return Optional.ofNullable(clazz.cast(this.portalProductId()));
            }
            case "ProductPageId": {
                return Optional.ofNullable(clazz.cast(this.productPageId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("portalProductId", PORTAL_PRODUCT_ID_FIELD);
        map.put("productPageId", PRODUCT_PAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteProductPageRequest, T> g) {
        return obj -> g.apply((DeleteProductPageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String portalProductId;
        private String productPageId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProductPageRequest model) {
            super(model);
            this.portalProductId(model.portalProductId);
            this.productPageId(model.productPageId);
        }

        public final String getPortalProductId() {
            return this.portalProductId;
        }

        public final void setPortalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
        }

        @Override
        public final Builder portalProductId(String portalProductId) {
            this.portalProductId = portalProductId;
            return this;
        }

        public final String getProductPageId() {
            return this.productPageId;
        }

        public final void setProductPageId(String productPageId) {
            this.productPageId = productPageId;
        }

        @Override
        public final Builder productPageId(String productPageId) {
            this.productPageId = productPageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProductPageRequest build() {
            return new DeleteProductPageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProductPageRequest> {
        public Builder portalProductId(String var1);

        public Builder productPageId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

