/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleAction;
import software.amazon.awssdk.services.apigatewayv2.model.RoutingRuleCondition;
import software.amazon.awssdk.services.apigatewayv2.model.___listOfRoutingRuleActionCopier;
import software.amazon.awssdk.services.apigatewayv2.model.___listOfRoutingRuleConditionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRoutingRuleRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, PutRoutingRuleRequest> {
    private static final SdkField<List<RoutingRuleAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(PutRoutingRuleRequest.getter(PutRoutingRuleRequest::actions)).setter(PutRoutingRuleRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingRuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RoutingRuleCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Conditions").getter(PutRoutingRuleRequest.getter(PutRoutingRuleRequest::conditions)).setter(PutRoutingRuleRequest.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingRuleCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(PutRoutingRuleRequest.getter(PutRoutingRuleRequest::domainName)).setter(PutRoutingRuleRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainNameId").getter(PutRoutingRuleRequest.getter(PutRoutingRuleRequest::domainNameId)).setter(PutRoutingRuleRequest.setter(Builder::domainNameId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainNameId").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(PutRoutingRuleRequest.getter(PutRoutingRuleRequest::priority)).setter(PutRoutingRuleRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> ROUTING_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingRuleId").getter(PutRoutingRuleRequest.getter(PutRoutingRuleRequest::routingRuleId)).setter(PutRoutingRuleRequest.setter(Builder::routingRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("routingRuleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, CONDITIONS_FIELD, DOMAIN_NAME_FIELD, DOMAIN_NAME_ID_FIELD, PRIORITY_FIELD, ROUTING_RULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRoutingRuleRequest.memberNameToFieldInitializer();
    private final List<RoutingRuleAction> actions;
    private final List<RoutingRuleCondition> conditions;
    private final String domainName;
    private final String domainNameId;
    private final Integer priority;
    private final String routingRuleId;

    private PutRoutingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.conditions = builder.conditions;
        this.domainName = builder.domainName;
        this.domainNameId = builder.domainNameId;
        this.priority = builder.priority;
        this.routingRuleId = builder.routingRuleId;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<RoutingRuleAction> actions() {
        return this.actions;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<RoutingRuleCondition> conditions() {
        return this.conditions;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String domainNameId() {
        return this.domainNameId;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String routingRuleId() {
        return this.routingRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNameId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingRuleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRoutingRuleRequest)) {
            return false;
        }
        PutRoutingRuleRequest other = (PutRoutingRuleRequest)((Object)obj);
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainNameId(), other.domainNameId()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.routingRuleId(), other.routingRuleId());
    }

    public final String toString() {
        return ToString.builder((String)"PutRoutingRuleRequest").add("Actions", this.hasActions() ? this.actions() : null).add("Conditions", this.hasConditions() ? this.conditions() : null).add("DomainName", (Object)this.domainName()).add("DomainNameId", (Object)this.domainNameId()).add("Priority", (Object)this.priority()).add("RoutingRuleId", (Object)this.routingRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DomainNameId": {
                return Optional.ofNullable(clazz.cast(this.domainNameId()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RoutingRuleId": {
                return Optional.ofNullable(clazz.cast(this.routingRuleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actions", ACTIONS_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("domainNameId", DOMAIN_NAME_ID_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("routingRuleId", ROUTING_RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRoutingRuleRequest, T> g) {
        return obj -> g.apply((PutRoutingRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private List<RoutingRuleAction> actions = DefaultSdkAutoConstructList.getInstance();
        private List<RoutingRuleCondition> conditions = DefaultSdkAutoConstructList.getInstance();
        private String domainName;
        private String domainNameId;
        private Integer priority;
        private String routingRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRoutingRuleRequest model) {
            super(model);
            this.actions(model.actions);
            this.conditions(model.conditions);
            this.domainName(model.domainName);
            this.domainNameId(model.domainNameId);
            this.priority(model.priority);
            this.routingRuleId(model.routingRuleId);
        }

        public final List<RoutingRuleAction.Builder> getActions() {
            List<RoutingRuleAction.Builder> result = ___listOfRoutingRuleActionCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RoutingRuleAction.BuilderImpl> actions) {
            this.actions = ___listOfRoutingRuleActionCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RoutingRuleAction> actions) {
            this.actions = ___listOfRoutingRuleActionCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RoutingRuleAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RoutingRuleAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (RoutingRuleAction)((RoutingRuleAction.Builder)RoutingRuleAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RoutingRuleCondition.Builder> getConditions() {
            List<RoutingRuleCondition.Builder> result = ___listOfRoutingRuleConditionCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<RoutingRuleCondition.BuilderImpl> conditions) {
            this.conditions = ___listOfRoutingRuleConditionCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<RoutingRuleCondition> conditions) {
            this.conditions = ___listOfRoutingRuleConditionCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RoutingRuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RoutingRuleCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (RoutingRuleCondition)((RoutingRuleCondition.Builder)RoutingRuleCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainNameId() {
            return this.domainNameId;
        }

        public final void setDomainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
        }

        @Override
        public final Builder domainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getRoutingRuleId() {
            return this.routingRuleId;
        }

        public final void setRoutingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
        }

        @Override
        public final Builder routingRuleId(String routingRuleId) {
            this.routingRuleId = routingRuleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRoutingRuleRequest build() {
            return new PutRoutingRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRoutingRuleRequest> {
        public Builder actions(Collection<RoutingRuleAction> var1);

        public Builder actions(RoutingRuleAction ... var1);

        public Builder actions(Consumer<RoutingRuleAction.Builder> ... var1);

        public Builder conditions(Collection<RoutingRuleCondition> var1);

        public Builder conditions(RoutingRuleCondition ... var1);

        public Builder conditions(Consumer<RoutingRuleCondition.Builder> ... var1);

        public Builder domainName(String var1);

        public Builder domainNameId(String var1);

        public Builder priority(Integer var1);

        public Builder routingRuleId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

