/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PassthroughBehavior {
    WHEN_NO_MATCH("WHEN_NO_MATCH"),
    NEVER("NEVER"),
    WHEN_NO_TEMPLATES("WHEN_NO_TEMPLATES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PassthroughBehavior> VALUE_MAP;
    private final String value;

    private PassthroughBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PassthroughBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PassthroughBehavior> knownValues() {
        EnumSet<PassthroughBehavior> knownValues = EnumSet.allOf(PassthroughBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PassthroughBehavior.class, PassthroughBehavior::toString);
    }
}

