/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.GetRestApisRequest;
import software.amazon.awssdk.services.apigateway.model.GetRestApisResponse;
import software.amazon.awssdk.services.apigateway.model.RestApi;

public class GetRestApisIterable
implements SdkIterable<GetRestApisResponse> {
    private final ApiGatewayClient client;
    private final GetRestApisRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetRestApisIterable(ApiGatewayClient client, GetRestApisRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetRestApisResponseFetcher();
    }

    public Iterator<GetRestApisResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RestApi> items() {
        Function<GetRestApisResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetRestApisResponseFetcher
    implements SyncPageFetcher<GetRestApisResponse> {
        private GetRestApisResponseFetcher() {
        }

        public boolean hasNextPage(GetRestApisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetRestApisResponse nextPage(GetRestApisResponse previousPage) {
            if (previousPage == null) {
                return GetRestApisIterable.this.client.getRestApis(GetRestApisIterable.this.firstRequest);
            }
            return GetRestApisIterable.this.client.getRestApis((GetRestApisRequest)((Object)GetRestApisIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

