/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApiKeysFormat {
    CSV("csv"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApiKeysFormat> VALUE_MAP;
    private final String value;

    private ApiKeysFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApiKeysFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApiKeysFormat> knownValues() {
        EnumSet<ApiKeysFormat> knownValues = EnumSet.allOf(ApiKeysFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApiKeysFormat.class, ApiKeysFormat::toString);
    }
}

