/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClientCertificateResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateClientCertificateResponse> {
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientCertificateId").getter(UpdateClientCertificateResponse.getter(UpdateClientCertificateResponse::clientCertificateId)).setter(UpdateClientCertificateResponse.setter(Builder::clientCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateClientCertificateResponse.getter(UpdateClientCertificateResponse::description)).setter(UpdateClientCertificateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PEM_ENCODED_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pemEncodedCertificate").getter(UpdateClientCertificateResponse.getter(UpdateClientCertificateResponse::pemEncodedCertificate)).setter(UpdateClientCertificateResponse.setter(Builder::pemEncodedCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pemEncodedCertificate").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(UpdateClientCertificateResponse.getter(UpdateClientCertificateResponse::createdDate)).setter(UpdateClientCertificateResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationDate").getter(UpdateClientCertificateResponse.getter(UpdateClientCertificateResponse::expirationDate)).setter(UpdateClientCertificateResponse.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(UpdateClientCertificateResponse.getter(UpdateClientCertificateResponse::tags)).setter(UpdateClientCertificateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CERTIFICATE_ID_FIELD, DESCRIPTION_FIELD, PEM_ENCODED_CERTIFICATE_FIELD, CREATED_DATE_FIELD, EXPIRATION_DATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateClientCertificateResponse.memberNameToFieldInitializer();
    private final String clientCertificateId;
    private final String description;
    private final String pemEncodedCertificate;
    private final Instant createdDate;
    private final Instant expirationDate;
    private final Map<String, String> tags;

    private UpdateClientCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.clientCertificateId = builder.clientCertificateId;
        this.description = builder.description;
        this.pemEncodedCertificate = builder.pemEncodedCertificate;
        this.createdDate = builder.createdDate;
        this.expirationDate = builder.expirationDate;
        this.tags = builder.tags;
    }

    public final String clientCertificateId() {
        return this.clientCertificateId;
    }

    public final String description() {
        return this.description;
    }

    public final String pemEncodedCertificate() {
        return this.pemEncodedCertificate;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.pemEncodedCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClientCertificateResponse)) {
            return false;
        }
        UpdateClientCertificateResponse other = (UpdateClientCertificateResponse)((Object)obj);
        return Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.pemEncodedCertificate(), other.pemEncodedCertificate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClientCertificateResponse").add("ClientCertificateId", (Object)this.clientCertificateId()).add("Description", (Object)this.description()).add("PemEncodedCertificate", (Object)this.pemEncodedCertificate()).add("CreatedDate", (Object)this.createdDate()).add("ExpirationDate", (Object)this.expirationDate()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "pemEncodedCertificate": {
                return Optional.ofNullable(clazz.cast(this.pemEncodedCertificate()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("pemEncodedCertificate", PEM_ENCODED_CERTIFICATE_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("expirationDate", EXPIRATION_DATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClientCertificateResponse, T> g) {
        return obj -> g.apply((UpdateClientCertificateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String clientCertificateId;
        private String description;
        private String pemEncodedCertificate;
        private Instant createdDate;
        private Instant expirationDate;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClientCertificateResponse model) {
            super(model);
            this.clientCertificateId(model.clientCertificateId);
            this.description(model.description);
            this.pemEncodedCertificate(model.pemEncodedCertificate);
            this.createdDate(model.createdDate);
            this.expirationDate(model.expirationDate);
            this.tags(model.tags);
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPemEncodedCertificate() {
            return this.pemEncodedCertificate;
        }

        public final void setPemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
        }

        @Override
        public final Builder pemEncodedCertificate(String pemEncodedCertificate) {
            this.pemEncodedCertificate = pemEncodedCertificate;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOfStringToStringCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateClientCertificateResponse build() {
            return new UpdateClientCertificateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClientCertificateResponse> {
        public Builder clientCertificateId(String var1);

        public Builder description(String var1);

        public Builder pemEncodedCertificate(String var1);

        public Builder createdDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

