/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendClient;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendServiceClientConfiguration;
import software.amazon.awssdk.services.amplifybackend.internal.AmplifyBackendServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendException;
import software.amazon.awssdk.services.amplifybackend.model.BadRequestException;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.GatewayTimeoutException;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.ImportBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListS3BucketsResponse;
import software.amazon.awssdk.services.amplifybackend.model.NotFoundException;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsResponse;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.TooManyRequestsException;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendStorageResponse;
import software.amazon.awssdk.services.amplifybackend.transform.CloneBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendConfigRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.CreateTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.DeleteTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GenerateBackendApiModelsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendApiModelsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendJobRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.GetTokenRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ImportBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ImportBackendStorageRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ListBackendJobsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.ListS3BucketsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.RemoveAllBackendsRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.RemoveBackendConfigRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendApiRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendAuthRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendConfigRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendJobRequestMarshaller;
import software.amazon.awssdk.services.amplifybackend.transform.UpdateBackendStorageRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultAmplifyBackendClient
implements AmplifyBackendClient {
    private static final Logger log = Logger.loggerFor(DefaultAmplifyBackendClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAmplifyBackendClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"AmplifyBackend#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloneBackendResponse cloneBackend(CloneBackendRequest cloneBackendRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CloneBackendResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cloneBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, cloneBackendRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CloneBackend");
            CloneBackendResponse cloneBackendResponse = (CloneBackendResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CloneBackend").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cloneBackendRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CloneBackendRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cloneBackendResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$cloneBackend$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackendResponse createBackend(CreateBackendRequest createBackendRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackendResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, createBackendRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackend");
            CreateBackendResponse createBackendResponse = (CreateBackendResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackend").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackendRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackendRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackendResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$createBackend$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackendApiResponse createBackendAPI(CreateBackendApiRequest createBackendApiRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackendApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackendApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, createBackendApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackendAPI");
            CreateBackendApiResponse createBackendApiResponse = (CreateBackendApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackendAPI").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackendApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackendApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackendApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$createBackendAPI$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackendAuthResponse createBackendAuth(CreateBackendAuthRequest createBackendAuthRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackendAuthResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackendAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, createBackendAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackendAuth");
            CreateBackendAuthResponse createBackendAuthResponse = (CreateBackendAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackendAuth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackendAuthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackendAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackendAuthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$createBackendAuth$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackendConfigResponse createBackendConfig(CreateBackendConfigRequest createBackendConfigRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackendConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackendConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, createBackendConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackendConfig");
            CreateBackendConfigResponse createBackendConfigResponse = (CreateBackendConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackendConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackendConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackendConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackendConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$createBackendConfig$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackendStorageResponse createBackendStorage(CreateBackendStorageRequest createBackendStorageRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackendStorageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackendStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, createBackendStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackendStorage");
            CreateBackendStorageResponse createBackendStorageResponse = (CreateBackendStorageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackendStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackendStorageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackendStorageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackendStorageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$createBackendStorage$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTokenResponse createToken(CreateTokenRequest createTokenRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, createTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateToken");
            CreateTokenResponse createTokenResponse = (CreateTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$createToken$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackendResponse deleteBackend(DeleteBackendRequest deleteBackendRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackendResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, deleteBackendRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackend");
            DeleteBackendResponse deleteBackendResponse = (DeleteBackendResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackend").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackendRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackendRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackendResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$deleteBackend$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackendApiResponse deleteBackendAPI(DeleteBackendApiRequest deleteBackendApiRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackendApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackendApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, deleteBackendApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackendAPI");
            DeleteBackendApiResponse deleteBackendApiResponse = (DeleteBackendApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackendAPI").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackendApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackendApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackendApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$deleteBackendAPI$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackendAuthResponse deleteBackendAuth(DeleteBackendAuthRequest deleteBackendAuthRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackendAuthResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackendAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, deleteBackendAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackendAuth");
            DeleteBackendAuthResponse deleteBackendAuthResponse = (DeleteBackendAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackendAuth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackendAuthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackendAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackendAuthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$deleteBackendAuth$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackendStorageResponse deleteBackendStorage(DeleteBackendStorageRequest deleteBackendStorageRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackendStorageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackendStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, deleteBackendStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackendStorage");
            DeleteBackendStorageResponse deleteBackendStorageResponse = (DeleteBackendStorageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackendStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackendStorageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackendStorageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackendStorageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$deleteBackendStorage$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTokenResponse deleteToken(DeleteTokenRequest deleteTokenRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, deleteTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteToken");
            DeleteTokenResponse deleteTokenResponse = (DeleteTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$deleteToken$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateBackendApiModelsResponse generateBackendAPIModels(GenerateBackendApiModelsRequest generateBackendApiModelsRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateBackendApiModelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateBackendApiModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, generateBackendApiModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateBackendAPIModels");
            GenerateBackendApiModelsResponse generateBackendApiModelsResponse = (GenerateBackendApiModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateBackendAPIModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateBackendApiModelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateBackendApiModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateBackendApiModelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$generateBackendAPIModels$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendResponse getBackend(GetBackendRequest getBackendRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBackendRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, getBackendRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackend");
            GetBackendResponse getBackendResponse = (GetBackendResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackend").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBackendRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$getBackend$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendApiResponse getBackendAPI(GetBackendApiRequest getBackendApiRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBackendApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, getBackendApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackendAPI");
            GetBackendApiResponse getBackendApiResponse = (GetBackendApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackendAPI").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBackendApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$getBackendAPI$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendApiModelsResponse getBackendAPIModels(GetBackendApiModelsRequest getBackendApiModelsRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendApiModelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBackendApiModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, getBackendApiModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackendAPIModels");
            GetBackendApiModelsResponse getBackendApiModelsResponse = (GetBackendApiModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackendAPIModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBackendApiModelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendApiModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendApiModelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$getBackendAPIModels$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendAuthResponse getBackendAuth(GetBackendAuthRequest getBackendAuthRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendAuthResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBackendAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, getBackendAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackendAuth");
            GetBackendAuthResponse getBackendAuthResponse = (GetBackendAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackendAuth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBackendAuthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendAuthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$getBackendAuth$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendJobResponse getBackendJob(GetBackendJobRequest getBackendJobRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBackendJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, getBackendJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackendJob");
            GetBackendJobResponse getBackendJobResponse = (GetBackendJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackendJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBackendJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$getBackendJob$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBackendStorageResponse getBackendStorage(GetBackendStorageRequest getBackendStorageRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBackendStorageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBackendStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, getBackendStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBackendStorage");
            GetBackendStorageResponse getBackendStorageResponse = (GetBackendStorageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBackendStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getBackendStorageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBackendStorageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBackendStorageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$getBackendStorage$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTokenResponse getToken(GetTokenRequest getTokenRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, getTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetToken");
            GetTokenResponse getTokenResponse = (GetTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetToken").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$getToken$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportBackendAuthResponse importBackendAuth(ImportBackendAuthRequest importBackendAuthRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportBackendAuthResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importBackendAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, importBackendAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportBackendAuth");
            ImportBackendAuthResponse importBackendAuthResponse = (ImportBackendAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportBackendAuth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importBackendAuthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportBackendAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importBackendAuthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$importBackendAuth$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportBackendStorageResponse importBackendStorage(ImportBackendStorageRequest importBackendStorageRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportBackendStorageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importBackendStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, importBackendStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportBackendStorage");
            ImportBackendStorageResponse importBackendStorageResponse = (ImportBackendStorageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportBackendStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importBackendStorageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportBackendStorageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importBackendStorageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$importBackendStorage$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBackendJobsResponse listBackendJobs(ListBackendJobsRequest listBackendJobsRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackendJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBackendJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, listBackendJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBackendJobs");
            ListBackendJobsResponse listBackendJobsResponse = (ListBackendJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackendJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBackendJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBackendJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBackendJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$listBackendJobs$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListS3BucketsResponse listS3Buckets(ListS3BucketsRequest listS3BucketsRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListS3BucketsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listS3BucketsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, listS3BucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListS3Buckets");
            ListS3BucketsResponse listS3BucketsResponse = (ListS3BucketsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListS3Buckets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listS3BucketsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListS3BucketsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listS3BucketsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$listS3Buckets$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveAllBackendsResponse removeAllBackends(RemoveAllBackendsRequest removeAllBackendsRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAllBackendsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeAllBackendsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, removeAllBackendsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveAllBackends");
            RemoveAllBackendsResponse removeAllBackendsResponse = (RemoveAllBackendsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAllBackends").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeAllBackendsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveAllBackendsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeAllBackendsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$removeAllBackends$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveBackendConfigResponse removeBackendConfig(RemoveBackendConfigRequest removeBackendConfigRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveBackendConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeBackendConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, removeBackendConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveBackendConfig");
            RemoveBackendConfigResponse removeBackendConfigResponse = (RemoveBackendConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveBackendConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)removeBackendConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveBackendConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeBackendConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$removeBackendConfig$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBackendApiResponse updateBackendAPI(UpdateBackendApiRequest updateBackendApiRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBackendApiResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBackendApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, updateBackendApiRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBackendAPI");
            UpdateBackendApiResponse updateBackendApiResponse = (UpdateBackendApiResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBackendAPI").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBackendApiRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBackendApiRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBackendApiResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$updateBackendAPI$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBackendAuthResponse updateBackendAuth(UpdateBackendAuthRequest updateBackendAuthRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBackendAuthResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBackendAuthRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, updateBackendAuthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBackendAuth");
            UpdateBackendAuthResponse updateBackendAuthResponse = (UpdateBackendAuthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBackendAuth").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBackendAuthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBackendAuthRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBackendAuthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$updateBackendAuth$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBackendConfigResponse updateBackendConfig(UpdateBackendConfigRequest updateBackendConfigRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBackendConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBackendConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, updateBackendConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBackendConfig");
            UpdateBackendConfigResponse updateBackendConfigResponse = (UpdateBackendConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBackendConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBackendConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBackendConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBackendConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$updateBackendConfig$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBackendJobResponse updateBackendJob(UpdateBackendJobRequest updateBackendJobRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBackendJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBackendJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, updateBackendJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBackendJob");
            UpdateBackendJobResponse updateBackendJobResponse = (UpdateBackendJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBackendJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBackendJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBackendJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBackendJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$updateBackendJob$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBackendStorageResponse updateBackendStorage(UpdateBackendStorageRequest updateBackendStorageRequest) throws NotFoundException, GatewayTimeoutException, TooManyRequestsException, BadRequestException, AwsServiceException, SdkClientException, AmplifyBackendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBackendStorageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBackendStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAmplifyBackendClient.resolveMetricPublishers(clientConfiguration, updateBackendStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AmplifyBackend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBackendStorage");
            UpdateBackendStorageResponse updateBackendStorageResponse = (UpdateBackendStorageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBackendStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateBackendStorageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBackendStorageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBackendStorageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultAmplifyBackendClient.lambda$updateBackendStorage$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "amplifybackend";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AmplifyBackendServiceClientConfigurationBuilder serviceConfigBuilder = new AmplifyBackendServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AmplifyBackendException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final AmplifyBackendServiceClientConfiguration serviceClientConfiguration() {
        return new AmplifyBackendServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateBackendStorage$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBackendJob$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBackendConfig$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBackendAuth$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBackendAPI$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeBackendConfig$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeAllBackends$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listS3Buckets$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBackendJobs$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importBackendStorage$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importBackendAuth$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getToken$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBackendStorage$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBackendJob$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBackendAuth$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBackendAPIModels$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBackendAPI$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBackend$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$generateBackendAPIModels$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteToken$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackendStorage$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackendAuth$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackendAPI$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackend$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createToken$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackendStorage$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackendConfig$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackendAuth$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackendAPI$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackend$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cloneBackend$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

