/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackendResponse
extends AmplifyBackendResponse
implements ToCopyableBuilder<Builder, GetBackendResponse> {
    private static final SdkField<String> AMPLIFY_FEATURE_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmplifyFeatureFlags").getter(GetBackendResponse.getter(GetBackendResponse::amplifyFeatureFlags)).setter(GetBackendResponse.setter(Builder::amplifyFeatureFlags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amplifyFeatureFlags").build()}).build();
    private static final SdkField<String> AMPLIFY_META_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmplifyMetaConfig").getter(GetBackendResponse.getter(GetBackendResponse::amplifyMetaConfig)).setter(GetBackendResponse.setter(Builder::amplifyMetaConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amplifyMetaConfig").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(GetBackendResponse.getter(GetBackendResponse::appId)).setter(GetBackendResponse.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> APP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppName").getter(GetBackendResponse.getter(GetBackendResponse::appName)).setter(GetBackendResponse.setter(Builder::appName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appName").build()}).build();
    private static final SdkField<List<String>> BACKEND_ENVIRONMENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackendEnvironmentList").getter(GetBackendResponse.getter(GetBackendResponse::backendEnvironmentList)).setter(GetBackendResponse.setter(Builder::backendEnvironmentList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackendEnvironmentName").getter(GetBackendResponse.getter(GetBackendResponse::backendEnvironmentName)).setter(GetBackendResponse.setter(Builder::backendEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(GetBackendResponse.getter(GetBackendResponse::error)).setter(GetBackendResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMPLIFY_FEATURE_FLAGS_FIELD, AMPLIFY_META_CONFIG_FIELD, APP_ID_FIELD, APP_NAME_FIELD, BACKEND_ENVIRONMENT_LIST_FIELD, BACKEND_ENVIRONMENT_NAME_FIELD, ERROR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBackendResponse.memberNameToFieldInitializer();
    private final String amplifyFeatureFlags;
    private final String amplifyMetaConfig;
    private final String appId;
    private final String appName;
    private final List<String> backendEnvironmentList;
    private final String backendEnvironmentName;
    private final String error;

    private GetBackendResponse(BuilderImpl builder) {
        super(builder);
        this.amplifyFeatureFlags = builder.amplifyFeatureFlags;
        this.amplifyMetaConfig = builder.amplifyMetaConfig;
        this.appId = builder.appId;
        this.appName = builder.appName;
        this.backendEnvironmentList = builder.backendEnvironmentList;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.error = builder.error;
    }

    public final String amplifyFeatureFlags() {
        return this.amplifyFeatureFlags;
    }

    public final String amplifyMetaConfig() {
        return this.amplifyMetaConfig;
    }

    public final String appId() {
        return this.appId;
    }

    public final String appName() {
        return this.appName;
    }

    public final boolean hasBackendEnvironmentList() {
        return this.backendEnvironmentList != null && !(this.backendEnvironmentList instanceof SdkAutoConstructList);
    }

    public final List<String> backendEnvironmentList() {
        return this.backendEnvironmentList;
    }

    public final String backendEnvironmentName() {
        return this.backendEnvironmentName;
    }

    public final String error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.amplifyFeatureFlags());
        hashCode = 31 * hashCode + Objects.hashCode(this.amplifyMetaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackendEnvironmentList() ? this.backendEnvironmentList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendResponse)) {
            return false;
        }
        GetBackendResponse other = (GetBackendResponse)((Object)obj);
        return Objects.equals(this.amplifyFeatureFlags(), other.amplifyFeatureFlags()) && Objects.equals(this.amplifyMetaConfig(), other.amplifyMetaConfig()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appName(), other.appName()) && this.hasBackendEnvironmentList() == other.hasBackendEnvironmentList() && Objects.equals(this.backendEnvironmentList(), other.backendEnvironmentList()) && Objects.equals(this.backendEnvironmentName(), other.backendEnvironmentName()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackendResponse").add("AmplifyFeatureFlags", (Object)this.amplifyFeatureFlags()).add("AmplifyMetaConfig", (Object)this.amplifyMetaConfig()).add("AppId", (Object)this.appId()).add("AppName", (Object)this.appName()).add("BackendEnvironmentList", this.hasBackendEnvironmentList() ? this.backendEnvironmentList() : null).add("BackendEnvironmentName", (Object)this.backendEnvironmentName()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmplifyFeatureFlags": {
                return Optional.ofNullable(clazz.cast(this.amplifyFeatureFlags()));
            }
            case "AmplifyMetaConfig": {
                return Optional.ofNullable(clazz.cast(this.amplifyMetaConfig()));
            }
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "AppName": {
                return Optional.ofNullable(clazz.cast(this.appName()));
            }
            case "BackendEnvironmentList": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentList()));
            }
            case "BackendEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentName()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amplifyFeatureFlags", AMPLIFY_FEATURE_FLAGS_FIELD);
        map.put("amplifyMetaConfig", AMPLIFY_META_CONFIG_FIELD);
        map.put("appId", APP_ID_FIELD);
        map.put("appName", APP_NAME_FIELD);
        map.put("backendEnvironmentList", BACKEND_ENVIRONMENT_LIST_FIELD);
        map.put("backendEnvironmentName", BACKEND_ENVIRONMENT_NAME_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBackendResponse, T> g) {
        return obj -> g.apply((GetBackendResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendResponse.BuilderImpl
    implements Builder {
        private String amplifyFeatureFlags;
        private String amplifyMetaConfig;
        private String appId;
        private String appName;
        private List<String> backendEnvironmentList = DefaultSdkAutoConstructList.getInstance();
        private String backendEnvironmentName;
        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendResponse model) {
            super(model);
            this.amplifyFeatureFlags(model.amplifyFeatureFlags);
            this.amplifyMetaConfig(model.amplifyMetaConfig);
            this.appId(model.appId);
            this.appName(model.appName);
            this.backendEnvironmentList(model.backendEnvironmentList);
            this.backendEnvironmentName(model.backendEnvironmentName);
            this.error(model.error);
        }

        public final String getAmplifyFeatureFlags() {
            return this.amplifyFeatureFlags;
        }

        public final void setAmplifyFeatureFlags(String amplifyFeatureFlags) {
            this.amplifyFeatureFlags = amplifyFeatureFlags;
        }

        @Override
        public final Builder amplifyFeatureFlags(String amplifyFeatureFlags) {
            this.amplifyFeatureFlags = amplifyFeatureFlags;
            return this;
        }

        public final String getAmplifyMetaConfig() {
            return this.amplifyMetaConfig;
        }

        public final void setAmplifyMetaConfig(String amplifyMetaConfig) {
            this.amplifyMetaConfig = amplifyMetaConfig;
        }

        @Override
        public final Builder amplifyMetaConfig(String amplifyMetaConfig) {
            this.amplifyMetaConfig = amplifyMetaConfig;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppName() {
            return this.appName;
        }

        public final void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public final Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public final Collection<String> getBackendEnvironmentList() {
            if (this.backendEnvironmentList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.backendEnvironmentList;
        }

        public final void setBackendEnvironmentList(Collection<String> backendEnvironmentList) {
            this.backendEnvironmentList = ListOf__stringCopier.copy(backendEnvironmentList);
        }

        @Override
        public final Builder backendEnvironmentList(Collection<String> backendEnvironmentList) {
            this.backendEnvironmentList = ListOf__stringCopier.copy(backendEnvironmentList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendEnvironmentList(String ... backendEnvironmentList) {
            this.backendEnvironmentList(Arrays.asList(backendEnvironmentList));
            return this;
        }

        public final String getBackendEnvironmentName() {
            return this.backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public GetBackendResponse build() {
            return new GetBackendResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmplifyBackendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackendResponse> {
        public Builder amplifyFeatureFlags(String var1);

        public Builder amplifyMetaConfig(String var1);

        public Builder appId(String var1);

        public Builder appName(String var1);

        public Builder backendEnvironmentList(Collection<String> var1);

        public Builder backendEnvironmentList(String ... var1);

        public Builder backendEnvironmentName(String var1);

        public Builder error(String var1);
    }
}

