/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.endpoints.internal;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.amplifybackend.endpoints.internal.DefaultPartitionDataProvider;
import software.amazon.awssdk.services.amplifybackend.endpoints.internal.Partition;
import software.amazon.awssdk.services.amplifybackend.endpoints.internal.Partitions;
import software.amazon.awssdk.services.amplifybackend.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.amplifybackend.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.amplifybackend.endpoints.internal.RuleUrl;

@SdkInternalApi
public class RulesFunctions {
    private static final Pattern VALID_HOST_LABEL_SUBDOMAINS = Pattern.compile("[a-zA-Z\\d][a-zA-Z\\d\\-.]{0,62}");
    private static final Pattern VALID_HOST_LABEL = Pattern.compile("[a-zA-Z\\d][a-zA-Z\\d\\-]{0,62}");
    private static final Pattern VIRTUAL_HOSTABLE_BUCKET = Pattern.compile("[a-z\\d][a-z\\d\\-.]{1,61}[a-z\\d]");
    private static final Pattern VIRTUAL_HOSTABLE_BUCKET_NO_SUBDOMAINS = Pattern.compile("[a-z\\d][a-z\\d\\-]{1,61}[a-z\\d]");
    private static final Pattern NO_IPS = Pattern.compile("(\\d+\\.){3}\\d+");
    private static final Pattern NO_CONSECUTIVE_DASH_OR_DOTS = Pattern.compile(".*[.-]{2}.*");
    private static final String[] ENCODED_CHARACTERS = new String[]{"+", "*", "%7E"};
    private static final String[] ENCODED_CHARACTERS_REPLACEMENTS = new String[]{"%20", "%2A", "~"};
    private static final LazyValue<PartitionData> PARTITION_DATA = LazyValue.builder().initializer(RulesFunctions::loadPartitionData).build();
    private static final LazyValue<Partition> AWS_PARTITION = LazyValue.builder().initializer(RulesFunctions::findAwsPartition).build();

    public static String substring(String input, int start, int stop, boolean reverse) {
        int len = input.length();
        if (start >= stop || len < stop) {
            return null;
        }
        int realStart = start;
        int realStop = stop;
        if (reverse) {
            realStart = len - stop;
            realStop = len - start;
        }
        StringBuilder result = new StringBuilder(realStop - realStart);
        for (int idx = realStart; idx < realStop; ++idx) {
            char ch = input.charAt(idx);
            if (ch > '\u007f') {
                return null;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String uriEncode(String uri) {
        try {
            String encoded = URLEncoder.encode(uri, "UTF-8");
            for (int i = 0; i < ENCODED_CHARACTERS.length; ++i) {
                encoded = encoded.replace(ENCODED_CHARACTERS[i], ENCODED_CHARACTERS_REPLACEMENTS[i]);
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw SdkClientException.create((String)("Unable to URI encode value: " + uri), (Throwable)e);
        }
    }

    public static RuleUrl parseURL(String url) {
        try {
            return RuleUrl.parse(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static boolean isValidHostLabel(String value, boolean allowSubDomains) {
        if (allowSubDomains) {
            return VALID_HOST_LABEL_SUBDOMAINS.matcher(value).matches();
        }
        return VALID_HOST_LABEL.matcher(value).matches();
    }

    public static RulePartition awsPartition(String regionName) {
        PartitionData data = PARTITION_DATA.value();
        Partition matchedPartition = (Partition)data.regionMap.get(regionName);
        if (matchedPartition == null) {
            for (Partition p : data.partitions) {
                Pattern regex = Pattern.compile(p.regionRegex());
                if (!regex.matcher(regionName).matches()) continue;
                matchedPartition = p;
                break;
            }
        }
        if (matchedPartition == null) {
            matchedPartition = AWS_PARTITION.value();
        }
        return RulePartition.from(matchedPartition.id(), matchedPartition.outputs());
    }

    public static RuleArn awsParseArn(String value) {
        return RuleArn.parse(value);
    }

    public static boolean stringEquals(String left, String right) {
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public static <T> T listAccess(List<T> values, int index) {
        if (values == null) {
            return null;
        }
        if (index >= values.size()) {
            return null;
        }
        return values.get(index);
    }

    public static boolean awsIsVirtualHostableS3Bucket(String hostLabel, boolean allowSubDomains) {
        if (allowSubDomains) {
            return VIRTUAL_HOSTABLE_BUCKET.matcher(hostLabel).matches() && !NO_IPS.matcher(hostLabel).matches() && !NO_CONSECUTIVE_DASH_OR_DOTS.matcher(hostLabel).matches();
        }
        return VIRTUAL_HOSTABLE_BUCKET_NO_SUBDOMAINS.matcher(hostLabel).matches();
    }

    private static PartitionData loadPartitionData() {
        DefaultPartitionDataProvider provider = new DefaultPartitionDataProvider();
        Partitions partitions = provider.loadPartitions();
        PartitionData partitionData = new PartitionData();
        partitions.partitions().forEach(part -> {
            partitionData.partitions.add(part);
            part.regions().forEach((name, override) -> partitionData.regionMap.put(name, part));
        });
        return partitionData;
    }

    private static Partition findAwsPartition() {
        return PARTITION_DATA.value().partitions.stream().filter(p -> p.id().equalsIgnoreCase("aws")).findFirst().orElse(null);
    }

    private static final class LazyValue<T> {
        private final Supplier<T> initializer;
        private T value;
        private boolean initialized;

        private LazyValue(Builder<T> builder) {
            this.initializer = ((Builder)builder).initializer;
        }

        public T value() {
            if (!this.initialized) {
                this.value = this.initializer.get();
                this.initialized = true;
            }
            return this.value;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T> {
            private Supplier<T> initializer;

            public Builder<T> initializer(Supplier<T> initializer) {
                this.initializer = initializer;
                return this;
            }

            public LazyValue<T> build() {
                return new LazyValue(this);
            }
        }
    }

    private static class PartitionData {
        private final List<Partition> partitions = new ArrayList<Partition>();
        private final Map<String, Partition> regionMap = new HashMap<String, Partition>();

        private PartitionData() {
        }
    }
}

