/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.BackendAuthAppleProviderConfig;
import software.amazon.awssdk.services.amplifybackend.model.BackendAuthSocialProviderConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SocialProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SocialProviderSettings> {
    private static final SdkField<BackendAuthSocialProviderConfig> FACEBOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Facebook").getter(SocialProviderSettings.getter(SocialProviderSettings::facebook)).setter(SocialProviderSettings.setter(Builder::facebook)).constructor(BackendAuthSocialProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Facebook").build()}).build();
    private static final SdkField<BackendAuthSocialProviderConfig> GOOGLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Google").getter(SocialProviderSettings.getter(SocialProviderSettings::google)).setter(SocialProviderSettings.setter(Builder::google)).constructor(BackendAuthSocialProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Google").build()}).build();
    private static final SdkField<BackendAuthSocialProviderConfig> LOGIN_WITH_AMAZON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoginWithAmazon").getter(SocialProviderSettings.getter(SocialProviderSettings::loginWithAmazon)).setter(SocialProviderSettings.setter(Builder::loginWithAmazon)).constructor(BackendAuthSocialProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginWithAmazon").build()}).build();
    private static final SdkField<BackendAuthAppleProviderConfig> SIGN_IN_WITH_APPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SignInWithApple").getter(SocialProviderSettings.getter(SocialProviderSettings::signInWithApple)).setter(SocialProviderSettings.setter(Builder::signInWithApple)).constructor(BackendAuthAppleProviderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInWithApple").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACEBOOK_FIELD, GOOGLE_FIELD, LOGIN_WITH_AMAZON_FIELD, SIGN_IN_WITH_APPLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final BackendAuthSocialProviderConfig facebook;
    private final BackendAuthSocialProviderConfig google;
    private final BackendAuthSocialProviderConfig loginWithAmazon;
    private final BackendAuthAppleProviderConfig signInWithApple;

    private SocialProviderSettings(BuilderImpl builder) {
        this.facebook = builder.facebook;
        this.google = builder.google;
        this.loginWithAmazon = builder.loginWithAmazon;
        this.signInWithApple = builder.signInWithApple;
    }

    public final BackendAuthSocialProviderConfig facebook() {
        return this.facebook;
    }

    public final BackendAuthSocialProviderConfig google() {
        return this.google;
    }

    public final BackendAuthSocialProviderConfig loginWithAmazon() {
        return this.loginWithAmazon;
    }

    public final BackendAuthAppleProviderConfig signInWithApple() {
        return this.signInWithApple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.facebook());
        hashCode = 31 * hashCode + Objects.hashCode(this.google());
        hashCode = 31 * hashCode + Objects.hashCode(this.loginWithAmazon());
        hashCode = 31 * hashCode + Objects.hashCode(this.signInWithApple());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SocialProviderSettings)) {
            return false;
        }
        SocialProviderSettings other = (SocialProviderSettings)obj;
        return Objects.equals(this.facebook(), other.facebook()) && Objects.equals(this.google(), other.google()) && Objects.equals(this.loginWithAmazon(), other.loginWithAmazon()) && Objects.equals(this.signInWithApple(), other.signInWithApple());
    }

    public final String toString() {
        return ToString.builder((String)"SocialProviderSettings").add("Facebook", (Object)this.facebook()).add("Google", (Object)this.google()).add("LoginWithAmazon", (Object)this.loginWithAmazon()).add("SignInWithApple", (Object)this.signInWithApple()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Facebook": {
                return Optional.ofNullable(clazz.cast(this.facebook()));
            }
            case "Google": {
                return Optional.ofNullable(clazz.cast(this.google()));
            }
            case "LoginWithAmazon": {
                return Optional.ofNullable(clazz.cast(this.loginWithAmazon()));
            }
            case "SignInWithApple": {
                return Optional.ofNullable(clazz.cast(this.signInWithApple()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SocialProviderSettings, T> g) {
        return obj -> g.apply((SocialProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BackendAuthSocialProviderConfig facebook;
        private BackendAuthSocialProviderConfig google;
        private BackendAuthSocialProviderConfig loginWithAmazon;
        private BackendAuthAppleProviderConfig signInWithApple;

        private BuilderImpl() {
        }

        private BuilderImpl(SocialProviderSettings model) {
            this.facebook(model.facebook);
            this.google(model.google);
            this.loginWithAmazon(model.loginWithAmazon);
            this.signInWithApple(model.signInWithApple);
        }

        public final BackendAuthSocialProviderConfig.Builder getFacebook() {
            return this.facebook != null ? this.facebook.toBuilder() : null;
        }

        public final void setFacebook(BackendAuthSocialProviderConfig.BuilderImpl facebook) {
            this.facebook = facebook != null ? facebook.build() : null;
        }

        @Override
        @Transient
        public final Builder facebook(BackendAuthSocialProviderConfig facebook) {
            this.facebook = facebook;
            return this;
        }

        public final BackendAuthSocialProviderConfig.Builder getGoogle() {
            return this.google != null ? this.google.toBuilder() : null;
        }

        public final void setGoogle(BackendAuthSocialProviderConfig.BuilderImpl google) {
            this.google = google != null ? google.build() : null;
        }

        @Override
        @Transient
        public final Builder google(BackendAuthSocialProviderConfig google) {
            this.google = google;
            return this;
        }

        public final BackendAuthSocialProviderConfig.Builder getLoginWithAmazon() {
            return this.loginWithAmazon != null ? this.loginWithAmazon.toBuilder() : null;
        }

        public final void setLoginWithAmazon(BackendAuthSocialProviderConfig.BuilderImpl loginWithAmazon) {
            this.loginWithAmazon = loginWithAmazon != null ? loginWithAmazon.build() : null;
        }

        @Override
        @Transient
        public final Builder loginWithAmazon(BackendAuthSocialProviderConfig loginWithAmazon) {
            this.loginWithAmazon = loginWithAmazon;
            return this;
        }

        public final BackendAuthAppleProviderConfig.Builder getSignInWithApple() {
            return this.signInWithApple != null ? this.signInWithApple.toBuilder() : null;
        }

        public final void setSignInWithApple(BackendAuthAppleProviderConfig.BuilderImpl signInWithApple) {
            this.signInWithApple = signInWithApple != null ? signInWithApple.build() : null;
        }

        @Override
        @Transient
        public final Builder signInWithApple(BackendAuthAppleProviderConfig signInWithApple) {
            this.signInWithApple = signInWithApple;
            return this;
        }

        public SocialProviderSettings build() {
            return new SocialProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SocialProviderSettings> {
        public Builder facebook(BackendAuthSocialProviderConfig var1);

        default public Builder facebook(Consumer<BackendAuthSocialProviderConfig.Builder> facebook) {
            return this.facebook((BackendAuthSocialProviderConfig)((BackendAuthSocialProviderConfig.Builder)BackendAuthSocialProviderConfig.builder().applyMutation(facebook)).build());
        }

        public Builder google(BackendAuthSocialProviderConfig var1);

        default public Builder google(Consumer<BackendAuthSocialProviderConfig.Builder> google) {
            return this.google((BackendAuthSocialProviderConfig)((BackendAuthSocialProviderConfig.Builder)BackendAuthSocialProviderConfig.builder().applyMutation(google)).build());
        }

        public Builder loginWithAmazon(BackendAuthSocialProviderConfig var1);

        default public Builder loginWithAmazon(Consumer<BackendAuthSocialProviderConfig.Builder> loginWithAmazon) {
            return this.loginWithAmazon((BackendAuthSocialProviderConfig)((BackendAuthSocialProviderConfig.Builder)BackendAuthSocialProviderConfig.builder().applyMutation(loginWithAmazon)).build());
        }

        public Builder signInWithApple(BackendAuthAppleProviderConfig var1);

        default public Builder signInWithApple(Consumer<BackendAuthAppleProviderConfig.Builder> signInWithApple) {
            return this.signInWithApple((BackendAuthAppleProviderConfig)((BackendAuthAppleProviderConfig.Builder)BackendAuthAppleProviderConfig.builder().applyMutation(signInWithApple)).build());
        }
    }
}

