/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.BackendStoragePermissions;
import software.amazon.awssdk.services.amplifybackend.model.ServiceName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendStorageResourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateBackendStorageResourceConfig> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(CreateBackendStorageResourceConfig.getter(CreateBackendStorageResourceConfig::bucketName)).setter(CreateBackendStorageResourceConfig.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<BackendStoragePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(CreateBackendStorageResourceConfig.getter(CreateBackendStorageResourceConfig::permissions)).setter(CreateBackendStorageResourceConfig.setter(Builder::permissions)).constructor(BackendStoragePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(CreateBackendStorageResourceConfig.getter(CreateBackendStorageResourceConfig::serviceNameAsString)).setter(CreateBackendStorageResourceConfig.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, PERMISSIONS_FIELD, SERVICE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final BackendStoragePermissions permissions;
    private final String serviceName;

    private CreateBackendStorageResourceConfig(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.permissions = builder.permissions;
        this.serviceName = builder.serviceName;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final BackendStoragePermissions permissions() {
        return this.permissions;
    }

    public final ServiceName serviceName() {
        return ServiceName.fromValue(this.serviceName);
    }

    public final String serviceNameAsString() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendStorageResourceConfig)) {
            return false;
        }
        CreateBackendStorageResourceConfig other = (CreateBackendStorageResourceConfig)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.serviceNameAsString(), other.serviceNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackendStorageResourceConfig").add("BucketName", (Object)this.bucketName()).add("Permissions", (Object)this.permissions()).add("ServiceName", (Object)this.serviceNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendStorageResourceConfig, T> g) {
        return obj -> g.apply((CreateBackendStorageResourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private BackendStoragePermissions permissions;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendStorageResourceConfig model) {
            this.bucketName(model.bucketName);
            this.permissions(model.permissions);
            this.serviceName(model.serviceName);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final BackendStoragePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(BackendStoragePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        @Transient
        public final Builder permissions(BackendStoragePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        @Transient
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public CreateBackendStorageResourceConfig build() {
            return new CreateBackendStorageResourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateBackendStorageResourceConfig> {
        public Builder bucketName(String var1);

        public Builder permissions(BackendStoragePermissions var1);

        default public Builder permissions(Consumer<BackendStoragePermissions.Builder> permissions) {
            return this.permissions((BackendStoragePermissions)((BackendStoragePermissions.Builder)BackendStoragePermissions.builder().applyMutation(permissions)).build());
        }

        public Builder serviceName(String var1);

        public Builder serviceName(ServiceName var1);
    }
}

