/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.AuthenticatedElement;
import software.amazon.awssdk.services.amplifybackend.model.ListOfAuthenticatedElementCopier;
import software.amazon.awssdk.services.amplifybackend.model.ListOfUnAuthenticatedElementCopier;
import software.amazon.awssdk.services.amplifybackend.model.UnAuthenticatedElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackendStoragePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackendStoragePermissions> {
    private static final SdkField<List<String>> AUTHENTICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Authenticated").getter(BackendStoragePermissions.getter(BackendStoragePermissions::authenticatedAsStrings)).setter(BackendStoragePermissions.setter(Builder::authenticatedWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticated").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UN_AUTHENTICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnAuthenticated").getter(BackendStoragePermissions.getter(BackendStoragePermissions::unAuthenticatedAsStrings)).setter(BackendStoragePermissions.setter(Builder::unAuthenticatedWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unAuthenticated").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATED_FIELD, UN_AUTHENTICATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> authenticated;
    private final List<String> unAuthenticated;

    private BackendStoragePermissions(BuilderImpl builder) {
        this.authenticated = builder.authenticated;
        this.unAuthenticated = builder.unAuthenticated;
    }

    public final List<AuthenticatedElement> authenticated() {
        return ListOfAuthenticatedElementCopier.copyStringToEnum(this.authenticated);
    }

    public final boolean hasAuthenticated() {
        return this.authenticated != null && !(this.authenticated instanceof SdkAutoConstructList);
    }

    public final List<String> authenticatedAsStrings() {
        return this.authenticated;
    }

    public final List<UnAuthenticatedElement> unAuthenticated() {
        return ListOfUnAuthenticatedElementCopier.copyStringToEnum(this.unAuthenticated);
    }

    public final boolean hasUnAuthenticated() {
        return this.unAuthenticated != null && !(this.unAuthenticated instanceof SdkAutoConstructList);
    }

    public final List<String> unAuthenticatedAsStrings() {
        return this.unAuthenticated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticated() ? this.authenticatedAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnAuthenticated() ? this.unAuthenticatedAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendStoragePermissions)) {
            return false;
        }
        BackendStoragePermissions other = (BackendStoragePermissions)obj;
        return this.hasAuthenticated() == other.hasAuthenticated() && Objects.equals(this.authenticatedAsStrings(), other.authenticatedAsStrings()) && this.hasUnAuthenticated() == other.hasUnAuthenticated() && Objects.equals(this.unAuthenticatedAsStrings(), other.unAuthenticatedAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"BackendStoragePermissions").add("Authenticated", this.hasAuthenticated() ? this.authenticatedAsStrings() : null).add("UnAuthenticated", this.hasUnAuthenticated() ? this.unAuthenticatedAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authenticated": {
                return Optional.ofNullable(clazz.cast(this.authenticatedAsStrings()));
            }
            case "UnAuthenticated": {
                return Optional.ofNullable(clazz.cast(this.unAuthenticatedAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendStoragePermissions, T> g) {
        return obj -> g.apply((BackendStoragePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> authenticated = DefaultSdkAutoConstructList.getInstance();
        private List<String> unAuthenticated = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackendStoragePermissions model) {
            this.authenticatedWithStrings(model.authenticated);
            this.unAuthenticatedWithStrings(model.unAuthenticated);
        }

        public final Collection<String> getAuthenticated() {
            if (this.authenticated instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authenticated;
        }

        public final void setAuthenticated(Collection<String> authenticated) {
            this.authenticated = ListOfAuthenticatedElementCopier.copy(authenticated);
        }

        @Override
        @Transient
        public final Builder authenticatedWithStrings(Collection<String> authenticated) {
            this.authenticated = ListOfAuthenticatedElementCopier.copy(authenticated);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder authenticatedWithStrings(String ... authenticated) {
            this.authenticatedWithStrings(Arrays.asList(authenticated));
            return this;
        }

        @Override
        @Transient
        public final Builder authenticated(Collection<AuthenticatedElement> authenticated) {
            this.authenticated = ListOfAuthenticatedElementCopier.copyEnumToString(authenticated);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder authenticated(AuthenticatedElement ... authenticated) {
            this.authenticated(Arrays.asList(authenticated));
            return this;
        }

        public final Collection<String> getUnAuthenticated() {
            if (this.unAuthenticated instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unAuthenticated;
        }

        public final void setUnAuthenticated(Collection<String> unAuthenticated) {
            this.unAuthenticated = ListOfUnAuthenticatedElementCopier.copy(unAuthenticated);
        }

        @Override
        @Transient
        public final Builder unAuthenticatedWithStrings(Collection<String> unAuthenticated) {
            this.unAuthenticated = ListOfUnAuthenticatedElementCopier.copy(unAuthenticated);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unAuthenticatedWithStrings(String ... unAuthenticated) {
            this.unAuthenticatedWithStrings(Arrays.asList(unAuthenticated));
            return this;
        }

        @Override
        @Transient
        public final Builder unAuthenticated(Collection<UnAuthenticatedElement> unAuthenticated) {
            this.unAuthenticated = ListOfUnAuthenticatedElementCopier.copyEnumToString(unAuthenticated);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unAuthenticated(UnAuthenticatedElement ... unAuthenticated) {
            this.unAuthenticated(Arrays.asList(unAuthenticated));
            return this;
        }

        public BackendStoragePermissions build() {
            return new BackendStoragePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackendStoragePermissions> {
        public Builder authenticatedWithStrings(Collection<String> var1);

        public Builder authenticatedWithStrings(String ... var1);

        public Builder authenticated(Collection<AuthenticatedElement> var1);

        public Builder authenticated(AuthenticatedElement ... var1);

        public Builder unAuthenticatedWithStrings(Collection<String> var1);

        public Builder unAuthenticatedWithStrings(String ... var1);

        public Builder unAuthenticated(Collection<UnAuthenticatedElement> var1);

        public Builder unAuthenticated(UnAuthenticatedElement ... var1);
    }
}

