/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendStorageResponse extends AmplifyBackendResponse implements
        ToCopyableBuilder<UpdateBackendStorageResponse.Builder, UpdateBackendStorageResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AppId")
            .getter(getter(UpdateBackendStorageResponse::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackendEnvironmentName").getter(getter(UpdateBackendStorageResponse::backendEnvironmentName))
            .setter(setter(Builder::backendEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build())
            .build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(UpdateBackendStorageResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateBackendStorageResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BACKEND_ENVIRONMENT_NAME_FIELD, JOB_ID_FIELD, STATUS_FIELD));

    private final String appId;

    private final String backendEnvironmentName;

    private final String jobId;

    private final String status;

    private UpdateBackendStorageResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.jobId = builder.jobId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment.
     * </p>
     * 
     * @return The name of the backend environment.
     */
    public final String backendEnvironmentName() {
        return backendEnvironmentName;
    }

    /**
     * <p>
     * The ID for the job.
     * </p>
     * 
     * @return The ID for the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current status of the request.
     * </p>
     * 
     * @return The current status of the request.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendStorageResponse)) {
            return false;
        }
        UpdateBackendStorageResponse other = (UpdateBackendStorageResponse) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(backendEnvironmentName(), other.backendEnvironmentName())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendStorageResponse").add("AppId", appId())
                .add("BackendEnvironmentName", backendEnvironmentName()).add("JobId", jobId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "BackendEnvironmentName":
            return Optional.ofNullable(clazz.cast(backendEnvironmentName()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendStorageResponse, T> g) {
        return obj -> g.apply((UpdateBackendStorageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyBackendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBackendStorageResponse> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment.
         * </p>
         * 
         * @param backendEnvironmentName
         *        The name of the backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentName(String backendEnvironmentName);

        /**
         * <p>
         * The ID for the job.
         * </p>
         * 
         * @param jobId
         *        The ID for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current status of the request.
         * </p>
         * 
         * @param status
         *        The current status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl extends AmplifyBackendResponse.BuilderImpl implements Builder {
        private String appId;

        private String backendEnvironmentName;

        private String jobId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendStorageResponse model) {
            super(model);
            appId(model.appId);
            backendEnvironmentName(model.backendEnvironmentName);
            jobId(model.jobId);
            status(model.status);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendEnvironmentName() {
            return backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        @Transient
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateBackendStorageResponse build() {
            return new UpdateBackendStorageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
