/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon Cognito user pool configuration for the auth resource to be configured for your Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackendAuthUserPoolConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateBackendAuthUserPoolConfig.Builder, CreateBackendAuthUserPoolConfig> {
    private static final SdkField<CreateBackendAuthForgotPasswordConfig> FORGOT_PASSWORD_FIELD = SdkField
            .<CreateBackendAuthForgotPasswordConfig> builder(MarshallingType.SDK_POJO).memberName("ForgotPassword")
            .getter(getter(CreateBackendAuthUserPoolConfig::forgotPassword)).setter(setter(Builder::forgotPassword))
            .constructor(CreateBackendAuthForgotPasswordConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forgotPassword").build()).build();

    private static final SdkField<CreateBackendAuthMFAConfig> MFA_FIELD = SdkField
            .<CreateBackendAuthMFAConfig> builder(MarshallingType.SDK_POJO).memberName("Mfa")
            .getter(getter(CreateBackendAuthUserPoolConfig::mfa)).setter(setter(Builder::mfa))
            .constructor(CreateBackendAuthMFAConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfa").build()).build();

    private static final SdkField<CreateBackendAuthOAuthConfig> O_AUTH_FIELD = SdkField
            .<CreateBackendAuthOAuthConfig> builder(MarshallingType.SDK_POJO).memberName("OAuth")
            .getter(getter(CreateBackendAuthUserPoolConfig::oAuth)).setter(setter(Builder::oAuth))
            .constructor(CreateBackendAuthOAuthConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth").build()).build();

    private static final SdkField<CreateBackendAuthPasswordPolicyConfig> PASSWORD_POLICY_FIELD = SdkField
            .<CreateBackendAuthPasswordPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("PasswordPolicy")
            .getter(getter(CreateBackendAuthUserPoolConfig::passwordPolicy)).setter(setter(Builder::passwordPolicy))
            .constructor(CreateBackendAuthPasswordPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordPolicy").build()).build();

    private static final SdkField<List<String>> REQUIRED_SIGN_UP_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RequiredSignUpAttributes")
            .getter(getter(CreateBackendAuthUserPoolConfig::requiredSignUpAttributesAsStrings))
            .setter(setter(Builder::requiredSignUpAttributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredSignUpAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SIGN_IN_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SignInMethod").getter(getter(CreateBackendAuthUserPoolConfig::signInMethodAsString))
            .setter(setter(Builder::signInMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signInMethod").build()).build();

    private static final SdkField<String> USER_POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolName").getter(getter(CreateBackendAuthUserPoolConfig::userPoolName))
            .setter(setter(Builder::userPoolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORGOT_PASSWORD_FIELD,
            MFA_FIELD, O_AUTH_FIELD, PASSWORD_POLICY_FIELD, REQUIRED_SIGN_UP_ATTRIBUTES_FIELD, SIGN_IN_METHOD_FIELD,
            USER_POOL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final CreateBackendAuthForgotPasswordConfig forgotPassword;

    private final CreateBackendAuthMFAConfig mfa;

    private final CreateBackendAuthOAuthConfig oAuth;

    private final CreateBackendAuthPasswordPolicyConfig passwordPolicy;

    private final List<String> requiredSignUpAttributes;

    private final String signInMethod;

    private final String userPoolName;

    private CreateBackendAuthUserPoolConfig(BuilderImpl builder) {
        this.forgotPassword = builder.forgotPassword;
        this.mfa = builder.mfa;
        this.oAuth = builder.oAuth;
        this.passwordPolicy = builder.passwordPolicy;
        this.requiredSignUpAttributes = builder.requiredSignUpAttributes;
        this.signInMethod = builder.signInMethod;
        this.userPoolName = builder.userPoolName;
    }

    /**
     * <p>
     * Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of your Amplify
     * project.
     * </p>
     * 
     * @return Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of your
     *         Amplify project.
     */
    public final CreateBackendAuthForgotPasswordConfig forgotPassword() {
        return forgotPassword;
    }

    /**
     * <p>
     * Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured as a
     * part of your Amplify project.
     * </p>
     * 
     * @return Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool
     *         configured as a part of your Amplify project.
     */
    public final CreateBackendAuthMFAConfig mfa() {
        return mfa;
    }

    /**
     * <p>
     * Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify
     * project.
     * </p>
     * 
     * @return Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your
     *         Amplify project.
     */
    public final CreateBackendAuthOAuthConfig oAuth() {
        return oAuth;
    }

    /**
     * <p>
     * Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify project.
     * </p>
     * 
     * @return Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
     *         project.
     */
    public final CreateBackendAuthPasswordPolicyConfig passwordPolicy() {
        return passwordPolicy;
    }

    /**
     * <p>
     * The required attributes to sign up new users in the user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredSignUpAttributes} method.
     * </p>
     * 
     * @return The required attributes to sign up new users in the user pool.
     */
    public final List<RequiredSignUpAttributesElement> requiredSignUpAttributes() {
        return ListOfRequiredSignUpAttributesElementCopier.copyStringToEnum(requiredSignUpAttributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RequiredSignUpAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRequiredSignUpAttributes() {
        return requiredSignUpAttributes != null && !(requiredSignUpAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The required attributes to sign up new users in the user pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequiredSignUpAttributes} method.
     * </p>
     * 
     * @return The required attributes to sign up new users in the user pool.
     */
    public final List<String> requiredSignUpAttributesAsStrings() {
        return requiredSignUpAttributes;
    }

    /**
     * <p>
     * Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user pool,
     * configured as a part of your Amplify project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signInMethod} will
     * return {@link SignInMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signInMethodAsString}.
     * </p>
     * 
     * @return Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user
     *         pool, configured as a part of your Amplify project.
     * @see SignInMethod
     */
    public final SignInMethod signInMethod() {
        return SignInMethod.fromValue(signInMethod);
    }

    /**
     * <p>
     * Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user pool,
     * configured as a part of your Amplify project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signInMethod} will
     * return {@link SignInMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signInMethodAsString}.
     * </p>
     * 
     * @return Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user
     *         pool, configured as a part of your Amplify project.
     * @see SignInMethod
     */
    public final String signInMethodAsString() {
        return signInMethod;
    }

    /**
     * <p>
     * The Amazon Cognito user pool name.
     * </p>
     * 
     * @return The Amazon Cognito user pool name.
     */
    public final String userPoolName() {
        return userPoolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forgotPassword());
        hashCode = 31 * hashCode + Objects.hashCode(mfa());
        hashCode = 31 * hashCode + Objects.hashCode(oAuth());
        hashCode = 31 * hashCode + Objects.hashCode(passwordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequiredSignUpAttributes() ? requiredSignUpAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(signInMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthUserPoolConfig)) {
            return false;
        }
        CreateBackendAuthUserPoolConfig other = (CreateBackendAuthUserPoolConfig) obj;
        return Objects.equals(forgotPassword(), other.forgotPassword()) && Objects.equals(mfa(), other.mfa())
                && Objects.equals(oAuth(), other.oAuth()) && Objects.equals(passwordPolicy(), other.passwordPolicy())
                && hasRequiredSignUpAttributes() == other.hasRequiredSignUpAttributes()
                && Objects.equals(requiredSignUpAttributesAsStrings(), other.requiredSignUpAttributesAsStrings())
                && Objects.equals(signInMethodAsString(), other.signInMethodAsString())
                && Objects.equals(userPoolName(), other.userPoolName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackendAuthUserPoolConfig").add("ForgotPassword", forgotPassword()).add("Mfa", mfa())
                .add("OAuth", oAuth()).add("PasswordPolicy", passwordPolicy())
                .add("RequiredSignUpAttributes", hasRequiredSignUpAttributes() ? requiredSignUpAttributesAsStrings() : null)
                .add("SignInMethod", signInMethodAsString()).add("UserPoolName", userPoolName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForgotPassword":
            return Optional.ofNullable(clazz.cast(forgotPassword()));
        case "Mfa":
            return Optional.ofNullable(clazz.cast(mfa()));
        case "OAuth":
            return Optional.ofNullable(clazz.cast(oAuth()));
        case "PasswordPolicy":
            return Optional.ofNullable(clazz.cast(passwordPolicy()));
        case "RequiredSignUpAttributes":
            return Optional.ofNullable(clazz.cast(requiredSignUpAttributesAsStrings()));
        case "SignInMethod":
            return Optional.ofNullable(clazz.cast(signInMethodAsString()));
        case "UserPoolName":
            return Optional.ofNullable(clazz.cast(userPoolName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthUserPoolConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthUserPoolConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateBackendAuthUserPoolConfig> {
        /**
         * <p>
         * Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of your
         * Amplify project.
         * </p>
         * 
         * @param forgotPassword
         *        Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of
         *        your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forgotPassword(CreateBackendAuthForgotPasswordConfig forgotPassword);

        /**
         * <p>
         * Describes the forgotten password policy for your Amazon Cognito user pool, configured as a part of your
         * Amplify project.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateBackendAuthForgotPasswordConfig.Builder}
         * avoiding the need to create one manually via {@link CreateBackendAuthForgotPasswordConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateBackendAuthForgotPasswordConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #forgotPassword(CreateBackendAuthForgotPasswordConfig)}.
         * 
         * @param forgotPassword
         *        a consumer that will call methods on {@link CreateBackendAuthForgotPasswordConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forgotPassword(CreateBackendAuthForgotPasswordConfig)
         */
        default Builder forgotPassword(Consumer<CreateBackendAuthForgotPasswordConfig.Builder> forgotPassword) {
            return forgotPassword(CreateBackendAuthForgotPasswordConfig.builder().applyMutation(forgotPassword).build());
        }

        /**
         * <p>
         * Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured
         * as a part of your Amplify project.
         * </p>
         * 
         * @param mfa
         *        Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool
         *        configured as a part of your Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfa(CreateBackendAuthMFAConfig mfa);

        /**
         * <p>
         * Describes whether to apply multi-factor authentication policies for your Amazon Cognito user pool configured
         * as a part of your Amplify project.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateBackendAuthMFAConfig.Builder} avoiding the
         * need to create one manually via {@link CreateBackendAuthMFAConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateBackendAuthMFAConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #mfa(CreateBackendAuthMFAConfig)}.
         * 
         * @param mfa
         *        a consumer that will call methods on {@link CreateBackendAuthMFAConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfa(CreateBackendAuthMFAConfig)
         */
        default Builder mfa(Consumer<CreateBackendAuthMFAConfig.Builder> mfa) {
            return mfa(CreateBackendAuthMFAConfig.builder().applyMutation(mfa).build());
        }

        /**
         * <p>
         * Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * 
         * @param oAuth
         *        Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your
         *        Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuth(CreateBackendAuthOAuthConfig oAuth);

        /**
         * <p>
         * Describes the OAuth policy and rules for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateBackendAuthOAuthConfig.Builder} avoiding
         * the need to create one manually via {@link CreateBackendAuthOAuthConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateBackendAuthOAuthConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #oAuth(CreateBackendAuthOAuthConfig)}.
         * 
         * @param oAuth
         *        a consumer that will call methods on {@link CreateBackendAuthOAuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oAuth(CreateBackendAuthOAuthConfig)
         */
        default Builder oAuth(Consumer<CreateBackendAuthOAuthConfig.Builder> oAuth) {
            return oAuth(CreateBackendAuthOAuthConfig.builder().applyMutation(oAuth).build());
        }

        /**
         * <p>
         * Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * 
         * @param passwordPolicy
         *        Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
         *        project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordPolicy(CreateBackendAuthPasswordPolicyConfig passwordPolicy);

        /**
         * <p>
         * Describes the password policy for your Amazon Cognito user pool, configured as a part of your Amplify
         * project.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateBackendAuthPasswordPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link CreateBackendAuthPasswordPolicyConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateBackendAuthPasswordPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #passwordPolicy(CreateBackendAuthPasswordPolicyConfig)}.
         * 
         * @param passwordPolicy
         *        a consumer that will call methods on {@link CreateBackendAuthPasswordPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passwordPolicy(CreateBackendAuthPasswordPolicyConfig)
         */
        default Builder passwordPolicy(Consumer<CreateBackendAuthPasswordPolicyConfig.Builder> passwordPolicy) {
            return passwordPolicy(CreateBackendAuthPasswordPolicyConfig.builder().applyMutation(passwordPolicy).build());
        }

        /**
         * <p>
         * The required attributes to sign up new users in the user pool.
         * </p>
         * 
         * @param requiredSignUpAttributes
         *        The required attributes to sign up new users in the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredSignUpAttributesWithStrings(Collection<String> requiredSignUpAttributes);

        /**
         * <p>
         * The required attributes to sign up new users in the user pool.
         * </p>
         * 
         * @param requiredSignUpAttributes
         *        The required attributes to sign up new users in the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredSignUpAttributesWithStrings(String... requiredSignUpAttributes);

        /**
         * <p>
         * The required attributes to sign up new users in the user pool.
         * </p>
         * 
         * @param requiredSignUpAttributes
         *        The required attributes to sign up new users in the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredSignUpAttributes(Collection<RequiredSignUpAttributesElement> requiredSignUpAttributes);

        /**
         * <p>
         * The required attributes to sign up new users in the user pool.
         * </p>
         * 
         * @param requiredSignUpAttributes
         *        The required attributes to sign up new users in the user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiredSignUpAttributes(RequiredSignUpAttributesElement... requiredSignUpAttributes);

        /**
         * <p>
         * Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user pool,
         * configured as a part of your Amplify project.
         * </p>
         * 
         * @param signInMethod
         *        Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user
         *        pool, configured as a part of your Amplify project.
         * @see SignInMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignInMethod
         */
        Builder signInMethod(String signInMethod);

        /**
         * <p>
         * Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user pool,
         * configured as a part of your Amplify project.
         * </p>
         * 
         * @param signInMethod
         *        Describes the sign-in methods that your Amplify app users use to log in using the Amazon Cognito user
         *        pool, configured as a part of your Amplify project.
         * @see SignInMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignInMethod
         */
        Builder signInMethod(SignInMethod signInMethod);

        /**
         * <p>
         * The Amazon Cognito user pool name.
         * </p>
         * 
         * @param userPoolName
         *        The Amazon Cognito user pool name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolName(String userPoolName);
    }

    static final class BuilderImpl implements Builder {
        private CreateBackendAuthForgotPasswordConfig forgotPassword;

        private CreateBackendAuthMFAConfig mfa;

        private CreateBackendAuthOAuthConfig oAuth;

        private CreateBackendAuthPasswordPolicyConfig passwordPolicy;

        private List<String> requiredSignUpAttributes = DefaultSdkAutoConstructList.getInstance();

        private String signInMethod;

        private String userPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthUserPoolConfig model) {
            forgotPassword(model.forgotPassword);
            mfa(model.mfa);
            oAuth(model.oAuth);
            passwordPolicy(model.passwordPolicy);
            requiredSignUpAttributesWithStrings(model.requiredSignUpAttributes);
            signInMethod(model.signInMethod);
            userPoolName(model.userPoolName);
        }

        public final CreateBackendAuthForgotPasswordConfig.Builder getForgotPassword() {
            return forgotPassword != null ? forgotPassword.toBuilder() : null;
        }

        public final void setForgotPassword(CreateBackendAuthForgotPasswordConfig.BuilderImpl forgotPassword) {
            this.forgotPassword = forgotPassword != null ? forgotPassword.build() : null;
        }

        @Override
        @Transient
        public final Builder forgotPassword(CreateBackendAuthForgotPasswordConfig forgotPassword) {
            this.forgotPassword = forgotPassword;
            return this;
        }

        public final CreateBackendAuthMFAConfig.Builder getMfa() {
            return mfa != null ? mfa.toBuilder() : null;
        }

        public final void setMfa(CreateBackendAuthMFAConfig.BuilderImpl mfa) {
            this.mfa = mfa != null ? mfa.build() : null;
        }

        @Override
        @Transient
        public final Builder mfa(CreateBackendAuthMFAConfig mfa) {
            this.mfa = mfa;
            return this;
        }

        public final CreateBackendAuthOAuthConfig.Builder getOAuth() {
            return oAuth != null ? oAuth.toBuilder() : null;
        }

        public final void setOAuth(CreateBackendAuthOAuthConfig.BuilderImpl oAuth) {
            this.oAuth = oAuth != null ? oAuth.build() : null;
        }

        @Override
        @Transient
        public final Builder oAuth(CreateBackendAuthOAuthConfig oAuth) {
            this.oAuth = oAuth;
            return this;
        }

        public final CreateBackendAuthPasswordPolicyConfig.Builder getPasswordPolicy() {
            return passwordPolicy != null ? passwordPolicy.toBuilder() : null;
        }

        public final void setPasswordPolicy(CreateBackendAuthPasswordPolicyConfig.BuilderImpl passwordPolicy) {
            this.passwordPolicy = passwordPolicy != null ? passwordPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder passwordPolicy(CreateBackendAuthPasswordPolicyConfig passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        public final Collection<String> getRequiredSignUpAttributes() {
            if (requiredSignUpAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return requiredSignUpAttributes;
        }

        public final void setRequiredSignUpAttributes(Collection<String> requiredSignUpAttributes) {
            this.requiredSignUpAttributes = ListOfRequiredSignUpAttributesElementCopier.copy(requiredSignUpAttributes);
        }

        @Override
        @Transient
        public final Builder requiredSignUpAttributesWithStrings(Collection<String> requiredSignUpAttributes) {
            this.requiredSignUpAttributes = ListOfRequiredSignUpAttributesElementCopier.copy(requiredSignUpAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requiredSignUpAttributesWithStrings(String... requiredSignUpAttributes) {
            requiredSignUpAttributesWithStrings(Arrays.asList(requiredSignUpAttributes));
            return this;
        }

        @Override
        @Transient
        public final Builder requiredSignUpAttributes(Collection<RequiredSignUpAttributesElement> requiredSignUpAttributes) {
            this.requiredSignUpAttributes = ListOfRequiredSignUpAttributesElementCopier
                    .copyEnumToString(requiredSignUpAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requiredSignUpAttributes(RequiredSignUpAttributesElement... requiredSignUpAttributes) {
            requiredSignUpAttributes(Arrays.asList(requiredSignUpAttributes));
            return this;
        }

        public final String getSignInMethod() {
            return signInMethod;
        }

        public final void setSignInMethod(String signInMethod) {
            this.signInMethod = signInMethod;
        }

        @Override
        @Transient
        public final Builder signInMethod(String signInMethod) {
            this.signInMethod = signInMethod;
            return this;
        }

        @Override
        @Transient
        public final Builder signInMethod(SignInMethod signInMethod) {
            this.signInMethod(signInMethod == null ? null : signInMethod.toString());
            return this;
        }

        public final String getUserPoolName() {
            return userPoolName;
        }

        public final void setUserPoolName(String userPoolName) {
            this.userPoolName = userPoolName;
        }

        @Override
        @Transient
        public final Builder userPoolName(String userPoolName) {
            this.userPoolName = userPoolName;
            return this;
        }

        @Override
        public CreateBackendAuthUserPoolConfig build() {
            return new CreateBackendAuthUserPoolConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
