/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BuildComputeType {
    STANDARD_8_GB("STANDARD_8GB"),
    LARGE_16_GB("LARGE_16GB"),
    XLARGE_72_GB("XLARGE_72GB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BuildComputeType> VALUE_MAP;
    private final String value;

    private BuildComputeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BuildComputeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BuildComputeType> knownValues() {
        EnumSet<BuildComputeType> knownValues = EnumSet.allOf(BuildComputeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BuildComputeType.class, BuildComputeType::toString);
    }
}

