/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CacheConfigType {
    AMPLIFY_MANAGED("AMPLIFY_MANAGED"),
    AMPLIFY_MANAGED_NO_COOKIES("AMPLIFY_MANAGED_NO_COOKIES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CacheConfigType> VALUE_MAP;
    private final String value;

    private CacheConfigType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CacheConfigType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CacheConfigType> knownValues() {
        EnumSet<CacheConfigType> knownValues = EnumSet.allOf(CacheConfigType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CacheConfigType.class, CacheConfigType::toString);
    }
}

