/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.Destination;
import software.amazon.awssdk.services.amp.model.RoleConfiguration;
import software.amazon.awssdk.services.amp.model.ScrapeConfiguration;
import software.amazon.awssdk.services.amp.model.ScraperStatus;
import software.amazon.awssdk.services.amp.model.Source;
import software.amazon.awssdk.services.amp.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScraperDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScraperDescription> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(ScraperDescription.getter(ScraperDescription::alias)).setter(ScraperDescription.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ScraperDescription.getter(ScraperDescription::arn)).setter(ScraperDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ScraperDescription.getter(ScraperDescription::createdAt)).setter(ScraperDescription.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destination").getter(ScraperDescription.getter(ScraperDescription::destination)).setter(ScraperDescription.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(ScraperDescription.getter(ScraperDescription::lastModifiedAt)).setter(ScraperDescription.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(ScraperDescription.getter(ScraperDescription::roleArn)).setter(ScraperDescription.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<RoleConfiguration> ROLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("roleConfiguration").getter(ScraperDescription.getter(ScraperDescription::roleConfiguration)).setter(ScraperDescription.setter(Builder::roleConfiguration)).constructor(RoleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleConfiguration").build()}).build();
    private static final SdkField<ScrapeConfiguration> SCRAPE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scrapeConfiguration").getter(ScraperDescription.getter(ScraperDescription::scrapeConfiguration)).setter(ScraperDescription.setter(Builder::scrapeConfiguration)).constructor(ScrapeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapeConfiguration").build()}).build();
    private static final SdkField<String> SCRAPER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scraperId").getter(ScraperDescription.getter(ScraperDescription::scraperId)).setter(ScraperDescription.setter(Builder::scraperId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scraperId").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(ScraperDescription.getter(ScraperDescription::source)).setter(ScraperDescription.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<ScraperStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ScraperDescription.getter(ScraperDescription::status)).setter(ScraperDescription.setter(Builder::status)).constructor(ScraperStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(ScraperDescription.getter(ScraperDescription::statusReason)).setter(ScraperDescription.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ScraperDescription.getter(ScraperDescription::tags)).setter(ScraperDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, ARN_FIELD, CREATED_AT_FIELD, DESTINATION_FIELD, LAST_MODIFIED_AT_FIELD, ROLE_ARN_FIELD, ROLE_CONFIGURATION_FIELD, SCRAPE_CONFIGURATION_FIELD, SCRAPER_ID_FIELD, SOURCE_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScraperDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final String arn;
    private final Instant createdAt;
    private final Destination destination;
    private final Instant lastModifiedAt;
    private final String roleArn;
    private final RoleConfiguration roleConfiguration;
    private final ScrapeConfiguration scrapeConfiguration;
    private final String scraperId;
    private final Source source;
    private final ScraperStatus status;
    private final String statusReason;
    private final Map<String, String> tags;

    private ScraperDescription(BuilderImpl builder) {
        this.alias = builder.alias;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.destination = builder.destination;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.roleArn = builder.roleArn;
        this.roleConfiguration = builder.roleConfiguration;
        this.scrapeConfiguration = builder.scrapeConfiguration;
        this.scraperId = builder.scraperId;
        this.source = builder.source;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
    }

    public final String alias() {
        return this.alias;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final RoleConfiguration roleConfiguration() {
        return this.roleConfiguration;
    }

    public final ScrapeConfiguration scrapeConfiguration() {
        return this.scrapeConfiguration;
    }

    public final String scraperId() {
        return this.scraperId;
    }

    public final Source source() {
        return this.source;
    }

    public final ScraperStatus status() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scrapeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scraperId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScraperDescription)) {
            return false;
        }
        ScraperDescription other = (ScraperDescription)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.roleConfiguration(), other.roleConfiguration()) && Objects.equals(this.scrapeConfiguration(), other.scrapeConfiguration()) && Objects.equals(this.scraperId(), other.scraperId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ScraperDescription").add("Alias", (Object)this.alias()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Destination", (Object)this.destination()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("RoleArn", (Object)this.roleArn()).add("RoleConfiguration", (Object)this.roleConfiguration()).add("ScrapeConfiguration", (Object)this.scrapeConfiguration()).add("ScraperId", (Object)this.scraperId()).add("Source", (Object)this.source()).add("Status", (Object)this.status()).add("StatusReason", (Object)this.statusReason()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "roleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.roleConfiguration()));
            }
            case "scrapeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scrapeConfiguration()));
            }
            case "scraperId": {
                return Optional.ofNullable(clazz.cast(this.scraperId()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alias", ALIAS_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("roleConfiguration", ROLE_CONFIGURATION_FIELD);
        map.put("scrapeConfiguration", SCRAPE_CONFIGURATION_FIELD);
        map.put("scraperId", SCRAPER_ID_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScraperDescription, T> g) {
        return obj -> g.apply((ScraperDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private String arn;
        private Instant createdAt;
        private Destination destination;
        private Instant lastModifiedAt;
        private String roleArn;
        private RoleConfiguration roleConfiguration;
        private ScrapeConfiguration scrapeConfiguration;
        private String scraperId;
        private Source source;
        private ScraperStatus status;
        private String statusReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScraperDescription model) {
            this.alias(model.alias);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.destination(model.destination);
            this.lastModifiedAt(model.lastModifiedAt);
            this.roleArn(model.roleArn);
            this.roleConfiguration(model.roleConfiguration);
            this.scrapeConfiguration(model.scrapeConfiguration);
            this.scraperId(model.scraperId);
            this.source(model.source);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.tags(model.tags);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final RoleConfiguration.Builder getRoleConfiguration() {
            return this.roleConfiguration != null ? this.roleConfiguration.toBuilder() : null;
        }

        public final void setRoleConfiguration(RoleConfiguration.BuilderImpl roleConfiguration) {
            this.roleConfiguration = roleConfiguration != null ? roleConfiguration.build() : null;
        }

        @Override
        public final Builder roleConfiguration(RoleConfiguration roleConfiguration) {
            this.roleConfiguration = roleConfiguration;
            return this;
        }

        public final ScrapeConfiguration.Builder getScrapeConfiguration() {
            return this.scrapeConfiguration != null ? this.scrapeConfiguration.toBuilder() : null;
        }

        public final void setScrapeConfiguration(ScrapeConfiguration.BuilderImpl scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration != null ? scrapeConfiguration.build() : null;
        }

        @Override
        public final Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        public final String getScraperId() {
            return this.scraperId;
        }

        public final void setScraperId(String scraperId) {
            this.scraperId = scraperId;
        }

        @Override
        public final Builder scraperId(String scraperId) {
            this.scraperId = scraperId;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final ScraperStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ScraperStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ScraperStatus status) {
            this.status = status;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public ScraperDescription build() {
            return new ScraperDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScraperDescription> {
        public Builder alias(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder lastModifiedAt(Instant var1);

        public Builder roleArn(String var1);

        public Builder roleConfiguration(RoleConfiguration var1);

        default public Builder roleConfiguration(Consumer<RoleConfiguration.Builder> roleConfiguration) {
            return this.roleConfiguration((RoleConfiguration)((RoleConfiguration.Builder)RoleConfiguration.builder().applyMutation(roleConfiguration)).build());
        }

        public Builder scrapeConfiguration(ScrapeConfiguration var1);

        default public Builder scrapeConfiguration(Consumer<ScrapeConfiguration.Builder> scrapeConfiguration) {
            return this.scrapeConfiguration((ScrapeConfiguration)((ScrapeConfiguration.Builder)ScrapeConfiguration.builder().applyMutation(scrapeConfiguration)).build());
        }

        public Builder scraperId(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder status(ScraperStatus var1);

        default public Builder status(Consumer<ScraperStatus.Builder> status) {
            return this.status((ScraperStatus)((ScraperStatus.Builder)ScraperStatus.builder().applyMutation(status)).build());
        }

        public Builder statusReason(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

