/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acmpca.model.AccessDescription;
import software.amazon.awssdk.services.acmpca.model.AccessDescriptionListCopier;
import software.amazon.awssdk.services.acmpca.model.KeyUsage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CsrExtensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CsrExtensions> {
    private static final SdkField<KeyUsage> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyUsage").getter(CsrExtensions.getter(CsrExtensions::keyUsage)).setter(CsrExtensions.setter(Builder::keyUsage)).constructor(KeyUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()}).build();
    private static final SdkField<List<AccessDescription>> SUBJECT_INFORMATION_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubjectInformationAccess").getter(CsrExtensions.getter(CsrExtensions::subjectInformationAccess)).setter(CsrExtensions.setter(Builder::subjectInformationAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectInformationAccess").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_USAGE_FIELD, SUBJECT_INFORMATION_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CsrExtensions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KeyUsage keyUsage;
    private final List<AccessDescription> subjectInformationAccess;

    private CsrExtensions(BuilderImpl builder) {
        this.keyUsage = builder.keyUsage;
        this.subjectInformationAccess = builder.subjectInformationAccess;
    }

    public final KeyUsage keyUsage() {
        return this.keyUsage;
    }

    public final boolean hasSubjectInformationAccess() {
        return this.subjectInformationAccess != null && !(this.subjectInformationAccess instanceof SdkAutoConstructList);
    }

    public final List<AccessDescription> subjectInformationAccess() {
        return this.subjectInformationAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectInformationAccess() ? this.subjectInformationAccess() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsrExtensions)) {
            return false;
        }
        CsrExtensions other = (CsrExtensions)obj;
        return Objects.equals(this.keyUsage(), other.keyUsage()) && this.hasSubjectInformationAccess() == other.hasSubjectInformationAccess() && Objects.equals(this.subjectInformationAccess(), other.subjectInformationAccess());
    }

    public final String toString() {
        return ToString.builder((String)"CsrExtensions").add("KeyUsage", (Object)this.keyUsage()).add("SubjectInformationAccess", this.hasSubjectInformationAccess() ? this.subjectInformationAccess() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsage()));
            }
            case "SubjectInformationAccess": {
                return Optional.ofNullable(clazz.cast(this.subjectInformationAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyUsage", KEY_USAGE_FIELD);
        map.put("SubjectInformationAccess", SUBJECT_INFORMATION_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CsrExtensions, T> g) {
        return obj -> g.apply((CsrExtensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KeyUsage keyUsage;
        private List<AccessDescription> subjectInformationAccess = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CsrExtensions model) {
            this.keyUsage(model.keyUsage);
            this.subjectInformationAccess(model.subjectInformationAccess);
        }

        public final KeyUsage.Builder getKeyUsage() {
            return this.keyUsage != null ? this.keyUsage.toBuilder() : null;
        }

        public final void setKeyUsage(KeyUsage.BuilderImpl keyUsage) {
            this.keyUsage = keyUsage != null ? keyUsage.build() : null;
        }

        @Override
        public final Builder keyUsage(KeyUsage keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        public final List<AccessDescription.Builder> getSubjectInformationAccess() {
            List<AccessDescription.Builder> result = AccessDescriptionListCopier.copyToBuilder(this.subjectInformationAccess);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubjectInformationAccess(Collection<AccessDescription.BuilderImpl> subjectInformationAccess) {
            this.subjectInformationAccess = AccessDescriptionListCopier.copyFromBuilder(subjectInformationAccess);
        }

        @Override
        public final Builder subjectInformationAccess(Collection<AccessDescription> subjectInformationAccess) {
            this.subjectInformationAccess = AccessDescriptionListCopier.copy(subjectInformationAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectInformationAccess(AccessDescription ... subjectInformationAccess) {
            this.subjectInformationAccess(Arrays.asList(subjectInformationAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectInformationAccess(Consumer<AccessDescription.Builder> ... subjectInformationAccess) {
            this.subjectInformationAccess(Stream.of(subjectInformationAccess).map(c -> (AccessDescription)((AccessDescription.Builder)AccessDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CsrExtensions build() {
            return new CsrExtensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CsrExtensions> {
        public Builder keyUsage(KeyUsage var1);

        default public Builder keyUsage(Consumer<KeyUsage.Builder> keyUsage) {
            return this.keyUsage((KeyUsage)((KeyUsage.Builder)KeyUsage.builder().applyMutation(keyUsage)).build());
        }

        public Builder subjectInformationAccess(Collection<AccessDescription> var1);

        public Builder subjectInformationAccess(AccessDescription ... var1);

        public Builder subjectInformationAccess(Consumer<AccessDescription.Builder> ... var1);
    }
}

