/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.AuditReportResponseFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCertificateAuthorityAuditReportRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, CreateCertificateAuthorityAuditReportRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(CreateCertificateAuthorityAuditReportRequest.getter(CreateCertificateAuthorityAuditReportRequest::certificateAuthorityArn)).setter(CreateCertificateAuthorityAuditReportRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(CreateCertificateAuthorityAuditReportRequest.getter(CreateCertificateAuthorityAuditReportRequest::s3BucketName)).setter(CreateCertificateAuthorityAuditReportRequest.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> AUDIT_REPORT_RESPONSE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditReportResponseFormat").getter(CreateCertificateAuthorityAuditReportRequest.getter(CreateCertificateAuthorityAuditReportRequest::auditReportResponseFormatAsString)).setter(CreateCertificateAuthorityAuditReportRequest.setter(Builder::auditReportResponseFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditReportResponseFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, S3_BUCKET_NAME_FIELD, AUDIT_REPORT_RESPONSE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCertificateAuthorityAuditReportRequest.memberNameToFieldInitializer();
    private final String certificateAuthorityArn;
    private final String s3BucketName;
    private final String auditReportResponseFormat;

    private CreateCertificateAuthorityAuditReportRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.s3BucketName = builder.s3BucketName;
        this.auditReportResponseFormat = builder.auditReportResponseFormat;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final AuditReportResponseFormat auditReportResponseFormat() {
        return AuditReportResponseFormat.fromValue(this.auditReportResponseFormat);
    }

    public final String auditReportResponseFormatAsString() {
        return this.auditReportResponseFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditReportResponseFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateAuthorityAuditReportRequest)) {
            return false;
        }
        CreateCertificateAuthorityAuditReportRequest other = (CreateCertificateAuthorityAuditReportRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.auditReportResponseFormatAsString(), other.auditReportResponseFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCertificateAuthorityAuditReportRequest").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("S3BucketName", (Object)this.s3BucketName()).add("AuditReportResponseFormat", (Object)this.auditReportResponseFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "AuditReportResponseFormat": {
                return Optional.ofNullable(clazz.cast(this.auditReportResponseFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("AuditReportResponseFormat", AUDIT_REPORT_RESPONSE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateAuthorityAuditReportRequest, T> g) {
        return obj -> g.apply((CreateCertificateAuthorityAuditReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private String s3BucketName;
        private String auditReportResponseFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateAuthorityAuditReportRequest model) {
            super(model);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.s3BucketName(model.s3BucketName);
            this.auditReportResponseFormat(model.auditReportResponseFormat);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getAuditReportResponseFormat() {
            return this.auditReportResponseFormat;
        }

        public final void setAuditReportResponseFormat(String auditReportResponseFormat) {
            this.auditReportResponseFormat = auditReportResponseFormat;
        }

        @Override
        public final Builder auditReportResponseFormat(String auditReportResponseFormat) {
            this.auditReportResponseFormat = auditReportResponseFormat;
            return this;
        }

        @Override
        public final Builder auditReportResponseFormat(AuditReportResponseFormat auditReportResponseFormat) {
            this.auditReportResponseFormat(auditReportResponseFormat == null ? null : auditReportResponseFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCertificateAuthorityAuditReportRequest build() {
            return new CreateCertificateAuthorityAuditReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCertificateAuthorityAuditReportRequest> {
        public Builder certificateAuthorityArn(String var1);

        public Builder s3BucketName(String var1);

        public Builder auditReportResponseFormat(String var1);

        public Builder auditReportResponseFormat(AuditReportResponseFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

