/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.services.acm.model.CertificateOptions;
import software.amazon.awssdk.services.acm.model.DomainListCopier;
import software.amazon.awssdk.services.acm.model.DomainValidationOption;
import software.amazon.awssdk.services.acm.model.DomainValidationOptionListCopier;
import software.amazon.awssdk.services.acm.model.KeyAlgorithm;
import software.amazon.awssdk.services.acm.model.Tag;
import software.amazon.awssdk.services.acm.model.TagListCopier;
import software.amazon.awssdk.services.acm.model.ValidationMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestCertificateRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, RequestCertificateRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(RequestCertificateRequest.getter(RequestCertificateRequest::domainName)).setter(RequestCertificateRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> VALIDATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationMethod").getter(RequestCertificateRequest.getter(RequestCertificateRequest::validationMethodAsString)).setter(RequestCertificateRequest.setter(Builder::validationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMethod").build()}).build();
    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubjectAlternativeNames").getter(RequestCertificateRequest.getter(RequestCertificateRequest::subjectAlternativeNames)).setter(RequestCertificateRequest.setter(Builder::subjectAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectAlternativeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(RequestCertificateRequest.getter(RequestCertificateRequest::idempotencyToken)).setter(RequestCertificateRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<List<DomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainValidationOptions").getter(RequestCertificateRequest.getter(RequestCertificateRequest::domainValidationOptions)).setter(RequestCertificateRequest.setter(Builder::domainValidationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainValidationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CertificateOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(RequestCertificateRequest.getter(RequestCertificateRequest::options)).setter(RequestCertificateRequest.setter(Builder::options)).constructor(CertificateOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(RequestCertificateRequest.getter(RequestCertificateRequest::certificateAuthorityArn)).setter(RequestCertificateRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RequestCertificateRequest.getter(RequestCertificateRequest::tags)).setter(RequestCertificateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAlgorithm").getter(RequestCertificateRequest.getter(RequestCertificateRequest::keyAlgorithmAsString)).setter(RequestCertificateRequest.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, VALIDATION_METHOD_FIELD, SUBJECT_ALTERNATIVE_NAMES_FIELD, IDEMPOTENCY_TOKEN_FIELD, DOMAIN_VALIDATION_OPTIONS_FIELD, OPTIONS_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, TAGS_FIELD, KEY_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestCertificateRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String validationMethod;
    private final List<String> subjectAlternativeNames;
    private final String idempotencyToken;
    private final List<DomainValidationOption> domainValidationOptions;
    private final CertificateOptions options;
    private final String certificateAuthorityArn;
    private final List<Tag> tags;
    private final String keyAlgorithm;

    private RequestCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.validationMethod = builder.validationMethod;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.idempotencyToken = builder.idempotencyToken;
        this.domainValidationOptions = builder.domainValidationOptions;
        this.options = builder.options;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.tags = builder.tags;
        this.keyAlgorithm = builder.keyAlgorithm;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ValidationMethod validationMethod() {
        return ValidationMethod.fromValue(this.validationMethod);
    }

    public final String validationMethodAsString() {
        return this.validationMethod;
    }

    public final boolean hasSubjectAlternativeNames() {
        return this.subjectAlternativeNames != null && !(this.subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    public final List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final boolean hasDomainValidationOptions() {
        return this.domainValidationOptions != null && !(this.domainValidationOptions instanceof SdkAutoConstructList);
    }

    public final List<DomainValidationOption> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public final CertificateOptions options() {
        return this.options;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public final String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationOptions() ? this.domainValidationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCertificateRequest)) {
            return false;
        }
        RequestCertificateRequest other = (RequestCertificateRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.validationMethodAsString(), other.validationMethodAsString()) && this.hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames() && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && this.hasDomainValidationOptions() == other.hasDomainValidationOptions() && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RequestCertificateRequest").add("DomainName", (Object)this.domainName()).add("ValidationMethod", (Object)this.validationMethodAsString()).add("SubjectAlternativeNames", this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).add("DomainValidationOptions", this.hasDomainValidationOptions() ? this.domainValidationOptions() : null).add("Options", (Object)this.options()).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("Tags", this.hasTags() ? this.tags() : null).add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ValidationMethod": {
                return Optional.ofNullable(clazz.cast(this.validationMethodAsString()));
            }
            case "SubjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNames()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "DomainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ValidationMethod", VALIDATION_METHOD_FIELD);
        map.put("SubjectAlternativeNames", SUBJECT_ALTERNATIVE_NAMES_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("DomainValidationOptions", DOMAIN_VALIDATION_OPTIONS_FIELD);
        map.put("Options", OPTIONS_FIELD);
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KeyAlgorithm", KEY_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestCertificateRequest, T> g) {
        return obj -> g.apply((RequestCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String validationMethod;
        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;
        private List<DomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();
        private CertificateOptions options;
        private String certificateAuthorityArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String keyAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestCertificateRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.validationMethod(model.validationMethod);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
            this.idempotencyToken(model.idempotencyToken);
            this.domainValidationOptions(model.domainValidationOptions);
            this.options(model.options);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.tags(model.tags);
            this.keyAlgorithm(model.keyAlgorithm);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getValidationMethod() {
            return this.validationMethod;
        }

        public final void setValidationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
        }

        @Override
        public final Builder validationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        @Override
        public final Builder validationMethod(ValidationMethod validationMethod) {
            this.validationMethod(validationMethod == null ? null : validationMethod.toString());
            return this;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            if (this.subjectAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subjectAlternativeNames;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final List<DomainValidationOption.Builder> getDomainValidationOptions() {
            List<DomainValidationOption.Builder> result = DomainValidationOptionListCopier.copyToBuilder(this.domainValidationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainValidationOptions(Collection<DomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationOptionListCopier.copyFromBuilder(domainValidationOptions);
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationOptionListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidationOption ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<DomainValidationOption.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (DomainValidationOption)((DomainValidationOption.Builder)DomainValidationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CertificateOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(CertificateOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(CertificateOptions options) {
            this.options = options;
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestCertificateRequest build() {
            return new RequestCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestCertificateRequest> {
        public Builder domainName(String var1);

        public Builder validationMethod(String var1);

        public Builder validationMethod(ValidationMethod var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder idempotencyToken(String var1);

        public Builder domainValidationOptions(Collection<DomainValidationOption> var1);

        public Builder domainValidationOptions(DomainValidationOption ... var1);

        public Builder domainValidationOptions(Consumer<DomainValidationOption.Builder> ... var1);

        public Builder options(CertificateOptions var1);

        default public Builder options(Consumer<CertificateOptions.Builder> options) {
            return this.options((CertificateOptions)((CertificateOptions.Builder)CertificateOptions.builder().applyMutation(options)).build());
        }

        public Builder certificateAuthorityArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

