/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AwsAccountState {
    PENDING_ACTIVATION("PENDING_ACTIVATION"),
    ACTIVE("ACTIVE"),
    SUSPENDED("SUSPENDED"),
    CLOSED("CLOSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AwsAccountState> VALUE_MAP;
    private final String value;

    private AwsAccountState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AwsAccountState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AwsAccountState> knownValues() {
        EnumSet<AwsAccountState> knownValues = EnumSet.allOf(AwsAccountState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AwsAccountState.class, AwsAccountState::toString);
    }
}

