/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.account.model.AccountResponse;
import software.amazon.awssdk.services.account.model.AwsAccountState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGovCloudAccountInformationResponse
extends AccountResponse
implements ToCopyableBuilder<Builder, GetGovCloudAccountInformationResponse> {
    private static final SdkField<String> ACCOUNT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountState").getter(GetGovCloudAccountInformationResponse.getter(GetGovCloudAccountInformationResponse::accountStateAsString)).setter(GetGovCloudAccountInformationResponse.setter(Builder::accountState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountState").build()}).build();
    private static final SdkField<String> GOV_CLOUD_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GovCloudAccountId").getter(GetGovCloudAccountInformationResponse.getter(GetGovCloudAccountInformationResponse::govCloudAccountId)).setter(GetGovCloudAccountInformationResponse.setter(Builder::govCloudAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GovCloudAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_STATE_FIELD, GOV_CLOUD_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetGovCloudAccountInformationResponse.memberNameToFieldInitializer();
    private final String accountState;
    private final String govCloudAccountId;

    private GetGovCloudAccountInformationResponse(BuilderImpl builder) {
        super(builder);
        this.accountState = builder.accountState;
        this.govCloudAccountId = builder.govCloudAccountId;
    }

    public final AwsAccountState accountState() {
        return AwsAccountState.fromValue(this.accountState);
    }

    public final String accountStateAsString() {
        return this.accountState;
    }

    public final String govCloudAccountId() {
        return this.govCloudAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.govCloudAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGovCloudAccountInformationResponse)) {
            return false;
        }
        GetGovCloudAccountInformationResponse other = (GetGovCloudAccountInformationResponse)((Object)obj);
        return Objects.equals(this.accountStateAsString(), other.accountStateAsString()) && Objects.equals(this.govCloudAccountId(), other.govCloudAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"GetGovCloudAccountInformationResponse").add("AccountState", (Object)this.accountStateAsString()).add("GovCloudAccountId", (Object)this.govCloudAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountState": {
                return Optional.ofNullable(clazz.cast(this.accountStateAsString()));
            }
            case "GovCloudAccountId": {
                return Optional.ofNullable(clazz.cast(this.govCloudAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountState", ACCOUNT_STATE_FIELD);
        map.put("GovCloudAccountId", GOV_CLOUD_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGovCloudAccountInformationResponse, T> g) {
        return obj -> g.apply((GetGovCloudAccountInformationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountResponse.BuilderImpl
    implements Builder {
        private String accountState;
        private String govCloudAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGovCloudAccountInformationResponse model) {
            super(model);
            this.accountState(model.accountState);
            this.govCloudAccountId(model.govCloudAccountId);
        }

        public final String getAccountState() {
            return this.accountState;
        }

        public final void setAccountState(String accountState) {
            this.accountState = accountState;
        }

        @Override
        public final Builder accountState(String accountState) {
            this.accountState = accountState;
            return this;
        }

        @Override
        public final Builder accountState(AwsAccountState accountState) {
            this.accountState(accountState == null ? null : accountState.toString());
            return this;
        }

        public final String getGovCloudAccountId() {
            return this.govCloudAccountId;
        }

        public final void setGovCloudAccountId(String govCloudAccountId) {
            this.govCloudAccountId = govCloudAccountId;
        }

        @Override
        public final Builder govCloudAccountId(String govCloudAccountId) {
            this.govCloudAccountId = govCloudAccountId;
            return this;
        }

        @Override
        public GetGovCloudAccountInformationResponse build() {
            return new GetGovCloudAccountInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGovCloudAccountInformationResponse> {
        public Builder accountState(String var1);

        public Builder accountState(AwsAccountState var1);

        public Builder govCloudAccountId(String var1);
    }
}

