/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.account.AccountClientBuilder;
import software.amazon.awssdk.services.account.AccountServiceClientConfiguration;
import software.amazon.awssdk.services.account.DefaultAccountClientBuilder;
import software.amazon.awssdk.services.account.model.AcceptPrimaryEmailUpdateRequest;
import software.amazon.awssdk.services.account.model.AcceptPrimaryEmailUpdateResponse;
import software.amazon.awssdk.services.account.model.AccessDeniedException;
import software.amazon.awssdk.services.account.model.AccountException;
import software.amazon.awssdk.services.account.model.ConflictException;
import software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest;
import software.amazon.awssdk.services.account.model.DeleteAlternateContactResponse;
import software.amazon.awssdk.services.account.model.DisableRegionRequest;
import software.amazon.awssdk.services.account.model.DisableRegionResponse;
import software.amazon.awssdk.services.account.model.EnableRegionRequest;
import software.amazon.awssdk.services.account.model.EnableRegionResponse;
import software.amazon.awssdk.services.account.model.GetAccountInformationRequest;
import software.amazon.awssdk.services.account.model.GetAccountInformationResponse;
import software.amazon.awssdk.services.account.model.GetAlternateContactRequest;
import software.amazon.awssdk.services.account.model.GetAlternateContactResponse;
import software.amazon.awssdk.services.account.model.GetContactInformationRequest;
import software.amazon.awssdk.services.account.model.GetContactInformationResponse;
import software.amazon.awssdk.services.account.model.GetPrimaryEmailRequest;
import software.amazon.awssdk.services.account.model.GetPrimaryEmailResponse;
import software.amazon.awssdk.services.account.model.GetRegionOptStatusRequest;
import software.amazon.awssdk.services.account.model.GetRegionOptStatusResponse;
import software.amazon.awssdk.services.account.model.InternalServerException;
import software.amazon.awssdk.services.account.model.ListRegionsRequest;
import software.amazon.awssdk.services.account.model.ListRegionsResponse;
import software.amazon.awssdk.services.account.model.PutAccountNameRequest;
import software.amazon.awssdk.services.account.model.PutAccountNameResponse;
import software.amazon.awssdk.services.account.model.PutAlternateContactRequest;
import software.amazon.awssdk.services.account.model.PutAlternateContactResponse;
import software.amazon.awssdk.services.account.model.PutContactInformationRequest;
import software.amazon.awssdk.services.account.model.PutContactInformationResponse;
import software.amazon.awssdk.services.account.model.ResourceNotFoundException;
import software.amazon.awssdk.services.account.model.StartPrimaryEmailUpdateRequest;
import software.amazon.awssdk.services.account.model.StartPrimaryEmailUpdateResponse;
import software.amazon.awssdk.services.account.model.TooManyRequestsException;
import software.amazon.awssdk.services.account.model.ValidationException;
import software.amazon.awssdk.services.account.paginators.ListRegionsIterable;

@SdkPublicApi
@ThreadSafe
public interface AccountClient
extends AwsClient {
    public static final String SERVICE_NAME = "account";
    public static final String SERVICE_METADATA_ID = "account";

    default public AcceptPrimaryEmailUpdateResponse acceptPrimaryEmailUpdate(AcceptPrimaryEmailUpdateRequest acceptPrimaryEmailUpdateRequest) throws ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public AcceptPrimaryEmailUpdateResponse acceptPrimaryEmailUpdate(Consumer<AcceptPrimaryEmailUpdateRequest.Builder> acceptPrimaryEmailUpdateRequest) throws ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.acceptPrimaryEmailUpdate((AcceptPrimaryEmailUpdateRequest)((Object)((AcceptPrimaryEmailUpdateRequest.Builder)AcceptPrimaryEmailUpdateRequest.builder().applyMutation(acceptPrimaryEmailUpdateRequest)).build()));
    }

    default public DeleteAlternateContactResponse deleteAlternateContact(DeleteAlternateContactRequest deleteAlternateContactRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public DeleteAlternateContactResponse deleteAlternateContact(Consumer<DeleteAlternateContactRequest.Builder> deleteAlternateContactRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.deleteAlternateContact((DeleteAlternateContactRequest)((Object)((DeleteAlternateContactRequest.Builder)DeleteAlternateContactRequest.builder().applyMutation(deleteAlternateContactRequest)).build()));
    }

    default public DisableRegionResponse disableRegion(DisableRegionRequest disableRegionRequest) throws AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public DisableRegionResponse disableRegion(Consumer<DisableRegionRequest.Builder> disableRegionRequest) throws AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.disableRegion((DisableRegionRequest)((Object)((DisableRegionRequest.Builder)DisableRegionRequest.builder().applyMutation(disableRegionRequest)).build()));
    }

    default public EnableRegionResponse enableRegion(EnableRegionRequest enableRegionRequest) throws AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public EnableRegionResponse enableRegion(Consumer<EnableRegionRequest.Builder> enableRegionRequest) throws AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.enableRegion((EnableRegionRequest)((Object)((EnableRegionRequest.Builder)EnableRegionRequest.builder().applyMutation(enableRegionRequest)).build()));
    }

    default public GetAccountInformationResponse getAccountInformation(GetAccountInformationRequest getAccountInformationRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public GetAccountInformationResponse getAccountInformation(Consumer<GetAccountInformationRequest.Builder> getAccountInformationRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.getAccountInformation((GetAccountInformationRequest)((Object)((GetAccountInformationRequest.Builder)GetAccountInformationRequest.builder().applyMutation(getAccountInformationRequest)).build()));
    }

    default public GetAlternateContactResponse getAlternateContact(GetAlternateContactRequest getAlternateContactRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public GetAlternateContactResponse getAlternateContact(Consumer<GetAlternateContactRequest.Builder> getAlternateContactRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.getAlternateContact((GetAlternateContactRequest)((Object)((GetAlternateContactRequest.Builder)GetAlternateContactRequest.builder().applyMutation(getAlternateContactRequest)).build()));
    }

    default public GetContactInformationResponse getContactInformation(GetContactInformationRequest getContactInformationRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public GetContactInformationResponse getContactInformation(Consumer<GetContactInformationRequest.Builder> getContactInformationRequest) throws ResourceNotFoundException, ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.getContactInformation((GetContactInformationRequest)((Object)((GetContactInformationRequest.Builder)GetContactInformationRequest.builder().applyMutation(getContactInformationRequest)).build()));
    }

    default public GetPrimaryEmailResponse getPrimaryEmail(GetPrimaryEmailRequest getPrimaryEmailRequest) throws ResourceNotFoundException, AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public GetPrimaryEmailResponse getPrimaryEmail(Consumer<GetPrimaryEmailRequest.Builder> getPrimaryEmailRequest) throws ResourceNotFoundException, AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.getPrimaryEmail((GetPrimaryEmailRequest)((Object)((GetPrimaryEmailRequest.Builder)GetPrimaryEmailRequest.builder().applyMutation(getPrimaryEmailRequest)).build()));
    }

    default public GetRegionOptStatusResponse getRegionOptStatus(GetRegionOptStatusRequest getRegionOptStatusRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public GetRegionOptStatusResponse getRegionOptStatus(Consumer<GetRegionOptStatusRequest.Builder> getRegionOptStatusRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.getRegionOptStatus((GetRegionOptStatusRequest)((Object)((GetRegionOptStatusRequest.Builder)GetRegionOptStatusRequest.builder().applyMutation(getRegionOptStatusRequest)).build()));
    }

    default public ListRegionsResponse listRegions(ListRegionsRequest listRegionsRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public ListRegionsResponse listRegions(Consumer<ListRegionsRequest.Builder> listRegionsRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.listRegions((ListRegionsRequest)((Object)((ListRegionsRequest.Builder)ListRegionsRequest.builder().applyMutation(listRegionsRequest)).build()));
    }

    default public ListRegionsIterable listRegionsPaginator(ListRegionsRequest listRegionsRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return new ListRegionsIterable(this, listRegionsRequest);
    }

    default public ListRegionsIterable listRegionsPaginator(Consumer<ListRegionsRequest.Builder> listRegionsRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.listRegionsPaginator((ListRegionsRequest)((Object)((ListRegionsRequest.Builder)ListRegionsRequest.builder().applyMutation(listRegionsRequest)).build()));
    }

    default public PutAccountNameResponse putAccountName(PutAccountNameRequest putAccountNameRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public PutAccountNameResponse putAccountName(Consumer<PutAccountNameRequest.Builder> putAccountNameRequest) throws AccessDeniedException, ValidationException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.putAccountName((PutAccountNameRequest)((Object)((PutAccountNameRequest.Builder)PutAccountNameRequest.builder().applyMutation(putAccountNameRequest)).build()));
    }

    default public PutAlternateContactResponse putAlternateContact(PutAlternateContactRequest putAlternateContactRequest) throws ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public PutAlternateContactResponse putAlternateContact(Consumer<PutAlternateContactRequest.Builder> putAlternateContactRequest) throws ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.putAlternateContact((PutAlternateContactRequest)((Object)((PutAlternateContactRequest.Builder)PutAlternateContactRequest.builder().applyMutation(putAlternateContactRequest)).build()));
    }

    default public PutContactInformationResponse putContactInformation(PutContactInformationRequest putContactInformationRequest) throws ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public PutContactInformationResponse putContactInformation(Consumer<PutContactInformationRequest.Builder> putContactInformationRequest) throws ValidationException, AccessDeniedException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.putContactInformation((PutContactInformationRequest)((Object)((PutContactInformationRequest.Builder)PutContactInformationRequest.builder().applyMutation(putContactInformationRequest)).build()));
    }

    default public StartPrimaryEmailUpdateResponse startPrimaryEmailUpdate(StartPrimaryEmailUpdateRequest startPrimaryEmailUpdateRequest) throws ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        throw new UnsupportedOperationException();
    }

    default public StartPrimaryEmailUpdateResponse startPrimaryEmailUpdate(Consumer<StartPrimaryEmailUpdateRequest.Builder> startPrimaryEmailUpdateRequest) throws ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, AccountException {
        return this.startPrimaryEmailUpdate((StartPrimaryEmailUpdateRequest)((Object)((StartPrimaryEmailUpdateRequest.Builder)StartPrimaryEmailUpdateRequest.builder().applyMutation(startPrimaryEmailUpdateRequest)).build()));
    }

    public static AccountClient create() {
        return (AccountClient)AccountClient.builder().build();
    }

    public static AccountClientBuilder builder() {
        return new DefaultAccountClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"account");
    }

    default public AccountServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

