/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.auth.scheme.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.account.auth.scheme.AccountAuthSchemeParams;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultAccountAuthSchemeParams
implements AccountAuthSchemeParams {
    private final String operation;
    private final Region region;

    private DefaultAccountAuthSchemeParams(Builder builder) {
        this.operation = (String)Validate.paramNotNull((Object)builder.operation, (String)"operation");
        this.region = builder.region;
    }

    public static AccountAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public AccountAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder
    implements AccountAuthSchemeParams.Builder {
        private String operation;
        private Region region;

        Builder() {
        }

        Builder(DefaultAccountAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public AccountAuthSchemeParams build() {
            return new DefaultAccountAuthSchemeParams(this);
        }
    }
}

