/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.FindingIdListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFindingsRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, UpdateFindingsRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerArn").getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::analyzerArn)).setter(UpdateFindingsRequest.setter(Builder::analyzerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::statusAsString)).setter(UpdateFindingsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ids").getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::ids)).setter(UpdateFindingsRequest.setter(Builder::ids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::resourceArn)).setter(UpdateFindingsRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateFindingsRequest.getter(UpdateFindingsRequest::clientToken)).setter(UpdateFindingsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD, STATUS_FIELD, IDS_FIELD, RESOURCE_ARN_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFindingsRequest.memberNameToFieldInitializer();
    private final String analyzerArn;
    private final String status;
    private final List<String> ids;
    private final String resourceArn;
    private final String clientToken;

    private UpdateFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.status = builder.status;
        this.ids = builder.ids;
        this.resourceArn = builder.resourceArn;
        this.clientToken = builder.clientToken;
    }

    public final String analyzerArn() {
        return this.analyzerArn;
    }

    public final FindingStatusUpdate status() {
        return FindingStatusUpdate.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasIds() {
        return this.ids != null && !(this.ids instanceof SdkAutoConstructList);
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIds() ? this.ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsRequest)) {
            return false;
        }
        UpdateFindingsRequest other = (UpdateFindingsRequest)((Object)obj);
        return Objects.equals(this.analyzerArn(), other.analyzerArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasIds() == other.hasIds() && Objects.equals(this.ids(), other.ids()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFindingsRequest").add("AnalyzerArn", (Object)this.analyzerArn()).add("Status", (Object)this.statusAsString()).add("Ids", this.hasIds() ? this.ids() : null).add("ResourceArn", (Object)this.resourceArn()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzerArn": {
                return Optional.ofNullable(clazz.cast(this.analyzerArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("analyzerArn", ANALYZER_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("ids", IDS_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsRequest, T> g) {
        return obj -> g.apply((UpdateFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String analyzerArn;
        private String status;
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();
        private String resourceArn;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsRequest model) {
            super(model);
            this.analyzerArn(model.analyzerArn);
            this.status(model.status);
            this.ids(model.ids);
            this.resourceArn(model.resourceArn);
            this.clientToken(model.clientToken);
        }

        public final String getAnalyzerArn() {
            return this.analyzerArn;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        @Override
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatusUpdate status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getIds() {
            if (this.ids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = FindingIdListCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = FindingIdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsRequest build() {
            return new UpdateFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFindingsRequest> {
        public Builder analyzerArn(String var1);

        public Builder status(String var1);

        public Builder status(FindingStatusUpdate var1);

        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder resourceArn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

