/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceControlPolicyRestriction {
    APPLICABLE("APPLICABLE"),
    FAILED_TO_EVALUATE_SCP("FAILED_TO_EVALUATE_SCP"),
    NOT_APPLICABLE("NOT_APPLICABLE"),
    APPLIED("APPLIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceControlPolicyRestriction> VALUE_MAP;
    private final String value;

    private ServiceControlPolicyRestriction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceControlPolicyRestriction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceControlPolicyRestriction> knownValues() {
        EnumSet<ServiceControlPolicyRestriction> knownValues = EnumSet.allOf(ServiceControlPolicyRestriction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceControlPolicyRestriction.class, ServiceControlPolicyRestriction::toString);
    }
}

