/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ExpressDirectoryAccessPointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ExpressDirectoryAccessPointConfiguration> {
    private static final SdkField<String> ACCESS_POINT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessPointPolicy").getter(S3ExpressDirectoryAccessPointConfiguration.getter(S3ExpressDirectoryAccessPointConfiguration::accessPointPolicy)).setter(S3ExpressDirectoryAccessPointConfiguration.setter(Builder::accessPointPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointPolicy").build()}).build();
    private static final SdkField<NetworkOriginConfiguration> NETWORK_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkOrigin").getter(S3ExpressDirectoryAccessPointConfiguration.getter(S3ExpressDirectoryAccessPointConfiguration::networkOrigin)).setter(S3ExpressDirectoryAccessPointConfiguration.setter(Builder::networkOrigin)).constructor(NetworkOriginConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOrigin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_POLICY_FIELD, NETWORK_ORIGIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ExpressDirectoryAccessPointConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessPointPolicy;
    private final NetworkOriginConfiguration networkOrigin;

    private S3ExpressDirectoryAccessPointConfiguration(BuilderImpl builder) {
        this.accessPointPolicy = builder.accessPointPolicy;
        this.networkOrigin = builder.networkOrigin;
    }

    public final String accessPointPolicy() {
        return this.accessPointPolicy;
    }

    public final NetworkOriginConfiguration networkOrigin() {
        return this.networkOrigin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOrigin());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExpressDirectoryAccessPointConfiguration)) {
            return false;
        }
        S3ExpressDirectoryAccessPointConfiguration other = (S3ExpressDirectoryAccessPointConfiguration)obj;
        return Objects.equals(this.accessPointPolicy(), other.accessPointPolicy()) && Objects.equals(this.networkOrigin(), other.networkOrigin());
    }

    public final String toString() {
        return ToString.builder((String)"S3ExpressDirectoryAccessPointConfiguration").add("AccessPointPolicy", (Object)this.accessPointPolicy()).add("NetworkOrigin", (Object)this.networkOrigin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPointPolicy": {
                return Optional.ofNullable(clazz.cast(this.accessPointPolicy()));
            }
            case "networkOrigin": {
                return Optional.ofNullable(clazz.cast(this.networkOrigin()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accessPointPolicy", ACCESS_POINT_POLICY_FIELD);
        map.put("networkOrigin", NETWORK_ORIGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ExpressDirectoryAccessPointConfiguration, T> g) {
        return obj -> g.apply((S3ExpressDirectoryAccessPointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessPointPolicy;
        private NetworkOriginConfiguration networkOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExpressDirectoryAccessPointConfiguration model) {
            this.accessPointPolicy(model.accessPointPolicy);
            this.networkOrigin(model.networkOrigin);
        }

        public final String getAccessPointPolicy() {
            return this.accessPointPolicy;
        }

        public final void setAccessPointPolicy(String accessPointPolicy) {
            this.accessPointPolicy = accessPointPolicy;
        }

        @Override
        public final Builder accessPointPolicy(String accessPointPolicy) {
            this.accessPointPolicy = accessPointPolicy;
            return this;
        }

        public final NetworkOriginConfiguration.Builder getNetworkOrigin() {
            return this.networkOrigin != null ? this.networkOrigin.toBuilder() : null;
        }

        public final void setNetworkOrigin(NetworkOriginConfiguration.BuilderImpl networkOrigin) {
            this.networkOrigin = networkOrigin != null ? networkOrigin.build() : null;
        }

        @Override
        public final Builder networkOrigin(NetworkOriginConfiguration networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        public S3ExpressDirectoryAccessPointConfiguration build() {
            return new S3ExpressDirectoryAccessPointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ExpressDirectoryAccessPointConfiguration> {
        public Builder accessPointPolicy(String var1);

        public Builder networkOrigin(NetworkOriginConfiguration var1);

        default public Builder networkOrigin(Consumer<NetworkOriginConfiguration.Builder> networkOrigin) {
            return this.networkOrigin((NetworkOriginConfiguration)((NetworkOriginConfiguration.Builder)NetworkOriginConfiguration.builder().applyMutation(networkOrigin)).build());
        }
    }
}

