/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReasonSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReasonSummary> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ReasonSummary.getter(ReasonSummary::description)).setter(ReasonSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> STATEMENT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("statementIndex").getter(ReasonSummary.getter(ReasonSummary::statementIndex)).setter(ReasonSummary.setter(Builder::statementIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementIndex").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statementId").getter(ReasonSummary.getter(ReasonSummary::statementId)).setter(ReasonSummary.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, STATEMENT_INDEX_FIELD, STATEMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReasonSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Integer statementIndex;
    private final String statementId;

    private ReasonSummary(BuilderImpl builder) {
        this.description = builder.description;
        this.statementIndex = builder.statementIndex;
        this.statementId = builder.statementId;
    }

    public final String description() {
        return this.description;
    }

    public final Integer statementIndex() {
        return this.statementIndex;
    }

    public final String statementId() {
        return this.statementId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReasonSummary)) {
            return false;
        }
        ReasonSummary other = (ReasonSummary)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.statementIndex(), other.statementIndex()) && Objects.equals(this.statementId(), other.statementId());
    }

    public final String toString() {
        return ToString.builder((String)"ReasonSummary").add("Description", (Object)this.description()).add("StatementIndex", (Object)this.statementIndex()).add("StatementId", (Object)this.statementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "statementIndex": {
                return Optional.ofNullable(clazz.cast(this.statementIndex()));
            }
            case "statementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("statementIndex", STATEMENT_INDEX_FIELD);
        map.put("statementId", STATEMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReasonSummary, T> g) {
        return obj -> g.apply((ReasonSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Integer statementIndex;
        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReasonSummary model) {
            this.description(model.description);
            this.statementIndex(model.statementIndex);
            this.statementId(model.statementId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStatementIndex() {
            return this.statementIndex;
        }

        public final void setStatementIndex(Integer statementIndex) {
            this.statementIndex = statementIndex;
        }

        @Override
        public final Builder statementIndex(Integer statementIndex) {
            this.statementIndex = statementIndex;
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public ReasonSummary build() {
            return new ReasonSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReasonSummary> {
        public Builder description(String var1);

        public Builder statementIndex(Integer var1);

        public Builder statementId(String var1);
    }
}

