/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.InternalAccessAnalysisRuleCriteria;
import software.amazon.awssdk.services.accessanalyzer.model.InternalAccessAnalysisRuleCriteriaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InternalAccessAnalysisRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InternalAccessAnalysisRule> {
    private static final SdkField<List<InternalAccessAnalysisRuleCriteria>> INCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inclusions").getter(InternalAccessAnalysisRule.getter(InternalAccessAnalysisRule::inclusions)).setter(InternalAccessAnalysisRule.setter(Builder::inclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InternalAccessAnalysisRuleCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InternalAccessAnalysisRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<InternalAccessAnalysisRuleCriteria> inclusions;

    private InternalAccessAnalysisRule(BuilderImpl builder) {
        this.inclusions = builder.inclusions;
    }

    public final boolean hasInclusions() {
        return this.inclusions != null && !(this.inclusions instanceof SdkAutoConstructList);
    }

    public final List<InternalAccessAnalysisRuleCriteria> inclusions() {
        return this.inclusions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusions() ? this.inclusions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalAccessAnalysisRule)) {
            return false;
        }
        InternalAccessAnalysisRule other = (InternalAccessAnalysisRule)obj;
        return this.hasInclusions() == other.hasInclusions() && Objects.equals(this.inclusions(), other.inclusions());
    }

    public final String toString() {
        return ToString.builder((String)"InternalAccessAnalysisRule").add("Inclusions", this.hasInclusions() ? this.inclusions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inclusions": {
                return Optional.ofNullable(clazz.cast(this.inclusions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<InternalAccessAnalysisRuleCriteria>>> map = new HashMap<String, SdkField<List<InternalAccessAnalysisRuleCriteria>>>();
        map.put("inclusions", INCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternalAccessAnalysisRule, T> g) {
        return obj -> g.apply((InternalAccessAnalysisRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InternalAccessAnalysisRuleCriteria> inclusions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InternalAccessAnalysisRule model) {
            this.inclusions(model.inclusions);
        }

        public final List<InternalAccessAnalysisRuleCriteria.Builder> getInclusions() {
            List<InternalAccessAnalysisRuleCriteria.Builder> result = InternalAccessAnalysisRuleCriteriaListCopier.copyToBuilder(this.inclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusions(Collection<InternalAccessAnalysisRuleCriteria.BuilderImpl> inclusions) {
            this.inclusions = InternalAccessAnalysisRuleCriteriaListCopier.copyFromBuilder(inclusions);
        }

        @Override
        public final Builder inclusions(Collection<InternalAccessAnalysisRuleCriteria> inclusions) {
            this.inclusions = InternalAccessAnalysisRuleCriteriaListCopier.copy(inclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusions(InternalAccessAnalysisRuleCriteria ... inclusions) {
            this.inclusions(Arrays.asList(inclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusions(Consumer<InternalAccessAnalysisRuleCriteria.Builder> ... inclusions) {
            this.inclusions(Stream.of(inclusions).map(c -> (InternalAccessAnalysisRuleCriteria)((InternalAccessAnalysisRuleCriteria.Builder)InternalAccessAnalysisRuleCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InternalAccessAnalysisRule build() {
            return new InternalAccessAnalysisRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InternalAccessAnalysisRule> {
        public Builder inclusions(Collection<InternalAccessAnalysisRuleCriteria> var1);

        public Builder inclusions(InternalAccessAnalysisRuleCriteria ... var1);

        public Builder inclusions(Consumer<InternalAccessAnalysisRuleCriteria.Builder> ... var1);
    }
}

