/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceTypeDetails;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceTypeStatisticsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalAccessFindingsStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalAccessFindingsStatistics> {
    private static final SdkField<Map<String, ResourceTypeDetails>> RESOURCE_TYPE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceTypeStatistics").getter(ExternalAccessFindingsStatistics.getter(ExternalAccessFindingsStatistics::resourceTypeStatisticsAsStrings)).setter(ExternalAccessFindingsStatistics.setter(Builder::resourceTypeStatisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypeStatistics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTypeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_ACTIVE_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalActiveFindings").getter(ExternalAccessFindingsStatistics.getter(ExternalAccessFindingsStatistics::totalActiveFindings)).setter(ExternalAccessFindingsStatistics.setter(Builder::totalActiveFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalActiveFindings").build()}).build();
    private static final SdkField<Integer> TOTAL_ARCHIVED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalArchivedFindings").getter(ExternalAccessFindingsStatistics.getter(ExternalAccessFindingsStatistics::totalArchivedFindings)).setter(ExternalAccessFindingsStatistics.setter(Builder::totalArchivedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalArchivedFindings").build()}).build();
    private static final SdkField<Integer> TOTAL_RESOLVED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalResolvedFindings").getter(ExternalAccessFindingsStatistics.getter(ExternalAccessFindingsStatistics::totalResolvedFindings)).setter(ExternalAccessFindingsStatistics.setter(Builder::totalResolvedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResolvedFindings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_STATISTICS_FIELD, TOTAL_ACTIVE_FINDINGS_FIELD, TOTAL_ARCHIVED_FINDINGS_FIELD, TOTAL_RESOLVED_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExternalAccessFindingsStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, ResourceTypeDetails> resourceTypeStatistics;
    private final Integer totalActiveFindings;
    private final Integer totalArchivedFindings;
    private final Integer totalResolvedFindings;

    private ExternalAccessFindingsStatistics(BuilderImpl builder) {
        this.resourceTypeStatistics = builder.resourceTypeStatistics;
        this.totalActiveFindings = builder.totalActiveFindings;
        this.totalArchivedFindings = builder.totalArchivedFindings;
        this.totalResolvedFindings = builder.totalResolvedFindings;
    }

    public final Map<ResourceType, ResourceTypeDetails> resourceTypeStatistics() {
        return ResourceTypeStatisticsMapCopier.copyStringToEnum(this.resourceTypeStatistics);
    }

    public final boolean hasResourceTypeStatistics() {
        return this.resourceTypeStatistics != null && !(this.resourceTypeStatistics instanceof SdkAutoConstructMap);
    }

    public final Map<String, ResourceTypeDetails> resourceTypeStatisticsAsStrings() {
        return this.resourceTypeStatistics;
    }

    public final Integer totalActiveFindings() {
        return this.totalActiveFindings;
    }

    public final Integer totalArchivedFindings() {
        return this.totalArchivedFindings;
    }

    public final Integer totalResolvedFindings() {
        return this.totalResolvedFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeStatistics() ? this.resourceTypeStatisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActiveFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalArchivedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResolvedFindings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalAccessFindingsStatistics)) {
            return false;
        }
        ExternalAccessFindingsStatistics other = (ExternalAccessFindingsStatistics)obj;
        return this.hasResourceTypeStatistics() == other.hasResourceTypeStatistics() && Objects.equals(this.resourceTypeStatisticsAsStrings(), other.resourceTypeStatisticsAsStrings()) && Objects.equals(this.totalActiveFindings(), other.totalActiveFindings()) && Objects.equals(this.totalArchivedFindings(), other.totalArchivedFindings()) && Objects.equals(this.totalResolvedFindings(), other.totalResolvedFindings());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalAccessFindingsStatistics").add("ResourceTypeStatistics", this.hasResourceTypeStatistics() ? this.resourceTypeStatisticsAsStrings() : null).add("TotalActiveFindings", (Object)this.totalActiveFindings()).add("TotalArchivedFindings", (Object)this.totalArchivedFindings()).add("TotalResolvedFindings", (Object)this.totalResolvedFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceTypeStatistics": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeStatisticsAsStrings()));
            }
            case "totalActiveFindings": {
                return Optional.ofNullable(clazz.cast(this.totalActiveFindings()));
            }
            case "totalArchivedFindings": {
                return Optional.ofNullable(clazz.cast(this.totalArchivedFindings()));
            }
            case "totalResolvedFindings": {
                return Optional.ofNullable(clazz.cast(this.totalResolvedFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceTypeStatistics", RESOURCE_TYPE_STATISTICS_FIELD);
        map.put("totalActiveFindings", TOTAL_ACTIVE_FINDINGS_FIELD);
        map.put("totalArchivedFindings", TOTAL_ARCHIVED_FINDINGS_FIELD);
        map.put("totalResolvedFindings", TOTAL_RESOLVED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalAccessFindingsStatistics, T> g) {
        return obj -> g.apply((ExternalAccessFindingsStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ResourceTypeDetails> resourceTypeStatistics = DefaultSdkAutoConstructMap.getInstance();
        private Integer totalActiveFindings;
        private Integer totalArchivedFindings;
        private Integer totalResolvedFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalAccessFindingsStatistics model) {
            this.resourceTypeStatisticsWithStrings(model.resourceTypeStatistics);
            this.totalActiveFindings(model.totalActiveFindings);
            this.totalArchivedFindings(model.totalArchivedFindings);
            this.totalResolvedFindings(model.totalResolvedFindings);
        }

        public final Map<String, ResourceTypeDetails.Builder> getResourceTypeStatistics() {
            Map<String, ResourceTypeDetails.Builder> result = ResourceTypeStatisticsMapCopier.copyToBuilder(this.resourceTypeStatistics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResourceTypeStatistics(Map<String, ResourceTypeDetails.BuilderImpl> resourceTypeStatistics) {
            this.resourceTypeStatistics = ResourceTypeStatisticsMapCopier.copyFromBuilder(resourceTypeStatistics);
        }

        @Override
        public final Builder resourceTypeStatisticsWithStrings(Map<String, ResourceTypeDetails> resourceTypeStatistics) {
            this.resourceTypeStatistics = ResourceTypeStatisticsMapCopier.copy(resourceTypeStatistics);
            return this;
        }

        @Override
        public final Builder resourceTypeStatistics(Map<ResourceType, ResourceTypeDetails> resourceTypeStatistics) {
            this.resourceTypeStatistics = ResourceTypeStatisticsMapCopier.copyEnumToString(resourceTypeStatistics);
            return this;
        }

        public final Integer getTotalActiveFindings() {
            return this.totalActiveFindings;
        }

        public final void setTotalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
        }

        @Override
        public final Builder totalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
            return this;
        }

        public final Integer getTotalArchivedFindings() {
            return this.totalArchivedFindings;
        }

        public final void setTotalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
        }

        @Override
        public final Builder totalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
            return this;
        }

        public final Integer getTotalResolvedFindings() {
            return this.totalResolvedFindings;
        }

        public final void setTotalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
        }

        @Override
        public final Builder totalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
            return this;
        }

        public ExternalAccessFindingsStatistics build() {
            return new ExternalAccessFindingsStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalAccessFindingsStatistics> {
        public Builder resourceTypeStatisticsWithStrings(Map<String, ResourceTypeDetails> var1);

        public Builder resourceTypeStatistics(Map<ResourceType, ResourceTypeDetails> var1);

        public Builder totalActiveFindings(Integer var1);

        public Builder totalArchivedFindings(Integer var1);

        public Builder totalResolvedFindings(Integer var1);
    }
}

