/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse;

public class ListArchiveRulesIterable
implements SdkIterable<ListArchiveRulesResponse> {
    private final AccessAnalyzerClient client;
    private final ListArchiveRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListArchiveRulesIterable(AccessAnalyzerClient client, ListArchiveRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListArchiveRulesResponseFetcher();
    }

    public Iterator<ListArchiveRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ArchiveRuleSummary> archiveRules() {
        Function<ListArchiveRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.archiveRules() != null) {
                return response.archiveRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListArchiveRulesResponseFetcher
    implements SyncPageFetcher<ListArchiveRulesResponse> {
        private ListArchiveRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListArchiveRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListArchiveRulesResponse nextPage(ListArchiveRulesResponse previousPage) {
            if (previousPage == null) {
                return ListArchiveRulesIterable.this.client.listArchiveRules(ListArchiveRulesIterable.this.firstRequest);
            }
            return ListArchiveRulesIterable.this.client.listArchiveRules((ListArchiveRulesRequest)((Object)ListArchiveRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

