/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotAttributeValue;
import software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotAttributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsDbSnapshotConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsDbSnapshotConfiguration> {
    private static final SdkField<Map<String, RdsDbSnapshotAttributeValue>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(RdsDbSnapshotConfiguration.getter(RdsDbSnapshotConfiguration::attributes)).setter(RdsDbSnapshotConfiguration.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RdsDbSnapshotAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(RdsDbSnapshotConfiguration.getter(RdsDbSnapshotConfiguration::kmsKeyId)).setter(RdsDbSnapshotConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, KMS_KEY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RdsDbSnapshotConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, RdsDbSnapshotAttributeValue> attributes;
    private final String kmsKeyId;

    private RdsDbSnapshotConfiguration(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, RdsDbSnapshotAttributeValue> attributes() {
        return this.attributes;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbSnapshotConfiguration)) {
            return false;
        }
        RdsDbSnapshotConfiguration other = (RdsDbSnapshotConfiguration)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"RdsDbSnapshotConfiguration").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsDbSnapshotConfiguration, T> g) {
        return obj -> g.apply((RdsDbSnapshotConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, RdsDbSnapshotAttributeValue> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbSnapshotConfiguration model) {
            this.attributes(model.attributes);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Map<String, RdsDbSnapshotAttributeValue.Builder> getAttributes() {
            Map<String, RdsDbSnapshotAttributeValue.Builder> result = RdsDbSnapshotAttributesMapCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, RdsDbSnapshotAttributeValue.BuilderImpl> attributes) {
            this.attributes = RdsDbSnapshotAttributesMapCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Map<String, RdsDbSnapshotAttributeValue> attributes) {
            this.attributes = RdsDbSnapshotAttributesMapCopier.copy(attributes);
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public RdsDbSnapshotConfiguration build() {
            return new RdsDbSnapshotConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsDbSnapshotConfiguration> {
        public Builder attributes(Map<String, RdsDbSnapshotAttributeValue> var1);

        public Builder kmsKeyId(String var1);
    }
}

