/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.FindingDetails;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingV2Request;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingV2Response;

public class GetFindingV2Iterable
implements SdkIterable<GetFindingV2Response> {
    private final AccessAnalyzerClient client;
    private final GetFindingV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFindingV2Iterable(AccessAnalyzerClient client, GetFindingV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetFindingV2ResponseFetcher();
    }

    public Iterator<GetFindingV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FindingDetails> findingDetails() {
        Function<GetFindingV2Response, Iterator> getIterator = response -> {
            if (response != null && response.findingDetails() != null) {
                return response.findingDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFindingV2ResponseFetcher
    implements SyncPageFetcher<GetFindingV2Response> {
        private GetFindingV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFindingV2Response nextPage(GetFindingV2Response previousPage) {
            if (previousPage == null) {
                return GetFindingV2Iterable.this.client.getFindingV2(GetFindingV2Iterable.this.firstRequest);
            }
            return GetFindingV2Iterable.this.client.getFindingV2((GetFindingV2Request)((Object)GetFindingV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

