/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.FindingsStatistics;
import software.amazon.awssdk.services.accessanalyzer.model.FindingsStatisticsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsStatisticsResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, GetFindingsStatisticsResponse> {
    private static final SdkField<List<FindingsStatistics>> FINDINGS_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingsStatistics").getter(GetFindingsStatisticsResponse.getter(GetFindingsStatisticsResponse::findingsStatistics)).setter(GetFindingsStatisticsResponse.setter(Builder::findingsStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingsStatistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingsStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetFindingsStatisticsResponse.getter(GetFindingsStatisticsResponse::lastUpdatedAt)).setter(GetFindingsStatisticsResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_STATISTICS_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFindingsStatisticsResponse.memberNameToFieldInitializer();
    private final List<FindingsStatistics> findingsStatistics;
    private final Instant lastUpdatedAt;

    private GetFindingsStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.findingsStatistics = builder.findingsStatistics;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final boolean hasFindingsStatistics() {
        return this.findingsStatistics != null && !(this.findingsStatistics instanceof SdkAutoConstructList);
    }

    public final List<FindingsStatistics> findingsStatistics() {
        return this.findingsStatistics;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingsStatistics() ? this.findingsStatistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsStatisticsResponse)) {
            return false;
        }
        GetFindingsStatisticsResponse other = (GetFindingsStatisticsResponse)((Object)obj);
        return this.hasFindingsStatistics() == other.hasFindingsStatistics() && Objects.equals(this.findingsStatistics(), other.findingsStatistics()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingsStatisticsResponse").add("FindingsStatistics", this.hasFindingsStatistics() ? this.findingsStatistics() : null).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingsStatistics": {
                return Optional.ofNullable(clazz.cast(this.findingsStatistics()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("findingsStatistics", FINDINGS_STATISTICS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsStatisticsResponse, T> g) {
        return obj -> g.apply((GetFindingsStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private List<FindingsStatistics> findingsStatistics = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsStatisticsResponse model) {
            super(model);
            this.findingsStatistics(model.findingsStatistics);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final List<FindingsStatistics.Builder> getFindingsStatistics() {
            List<FindingsStatistics.Builder> result = FindingsStatisticsListCopier.copyToBuilder(this.findingsStatistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingsStatistics(Collection<FindingsStatistics.BuilderImpl> findingsStatistics) {
            this.findingsStatistics = FindingsStatisticsListCopier.copyFromBuilder(findingsStatistics);
        }

        @Override
        public final Builder findingsStatistics(Collection<FindingsStatistics> findingsStatistics) {
            this.findingsStatistics = FindingsStatisticsListCopier.copy(findingsStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsStatistics(FindingsStatistics ... findingsStatistics) {
            this.findingsStatistics(Arrays.asList(findingsStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsStatistics(Consumer<FindingsStatistics.Builder> ... findingsStatistics) {
            this.findingsStatistics(Stream.of(findingsStatistics).map(c -> (FindingsStatistics)((FindingsStatistics.Builder)FindingsStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetFindingsStatisticsResponse build() {
            return new GetFindingsStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsStatisticsResponse> {
        public Builder findingsStatistics(Collection<FindingsStatistics> var1);

        public Builder findingsStatistics(FindingsStatistics ... var1);

        public Builder findingsStatistics(Consumer<FindingsStatistics.Builder> ... var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

