/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ActionListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ConditionKeyMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSource;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSourceListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.PrincipalMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceControlPolicyRestriction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalAccessDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalAccessDetails> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("action").getter(ExternalAccessDetails.getter(ExternalAccessDetails::action)).setter(ExternalAccessDetails.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("condition").getter(ExternalAccessDetails.getter(ExternalAccessDetails::condition)).setter(ExternalAccessDetails.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPublic").getter(ExternalAccessDetails.getter(ExternalAccessDetails::isPublic)).setter(ExternalAccessDetails.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()}).build();
    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("principal").getter(ExternalAccessDetails.getter(ExternalAccessDetails::principal)).setter(ExternalAccessDetails.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(ExternalAccessDetails.getter(ExternalAccessDetails::sources)).setter(ExternalAccessDetails.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceControlPolicyRestriction").getter(ExternalAccessDetails.getter(ExternalAccessDetails::resourceControlPolicyRestrictionAsString)).setter(ExternalAccessDetails.setter(Builder::resourceControlPolicyRestriction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceControlPolicyRestriction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, CONDITION_FIELD, IS_PUBLIC_FIELD, PRINCIPAL_FIELD, SOURCES_FIELD, RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExternalAccessDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> action;
    private final Map<String, String> condition;
    private final Boolean isPublic;
    private final Map<String, String> principal;
    private final List<FindingSource> sources;
    private final String resourceControlPolicyRestriction;

    private ExternalAccessDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.condition = builder.condition;
        this.isPublic = builder.isPublic;
        this.principal = builder.principal;
        this.sources = builder.sources;
        this.resourceControlPolicyRestriction = builder.resourceControlPolicyRestriction;
    }

    public final boolean hasAction() {
        return this.action != null && !(this.action instanceof SdkAutoConstructList);
    }

    public final List<String> action() {
        return this.action;
    }

    public final boolean hasCondition() {
        return this.condition != null && !(this.condition instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> condition() {
        return this.condition;
    }

    public final Boolean isPublic() {
        return this.isPublic;
    }

    public final boolean hasPrincipal() {
        return this.principal != null && !(this.principal instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> principal() {
        return this.principal;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<FindingSource> sources() {
        return this.sources;
    }

    public final ResourceControlPolicyRestriction resourceControlPolicyRestriction() {
        return ResourceControlPolicyRestriction.fromValue(this.resourceControlPolicyRestriction);
    }

    public final String resourceControlPolicyRestrictionAsString() {
        return this.resourceControlPolicyRestriction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAction() ? this.action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCondition() ? this.condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipal() ? this.principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceControlPolicyRestrictionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalAccessDetails)) {
            return false;
        }
        ExternalAccessDetails other = (ExternalAccessDetails)obj;
        return this.hasAction() == other.hasAction() && Objects.equals(this.action(), other.action()) && this.hasCondition() == other.hasCondition() && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.isPublic(), other.isPublic()) && this.hasPrincipal() == other.hasPrincipal() && Objects.equals(this.principal(), other.principal()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.resourceControlPolicyRestrictionAsString(), other.resourceControlPolicyRestrictionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalAccessDetails").add("Action", this.hasAction() ? this.action() : null).add("Condition", this.hasCondition() ? this.condition() : null).add("IsPublic", (Object)this.isPublic()).add("Principal", this.hasPrincipal() ? this.principal() : null).add("Sources", this.hasSources() ? this.sources() : null).add("ResourceControlPolicyRestriction", (Object)this.resourceControlPolicyRestrictionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "resourceControlPolicyRestriction": {
                return Optional.ofNullable(clazz.cast(this.resourceControlPolicyRestrictionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("isPublic", IS_PUBLIC_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("resourceControlPolicyRestriction", RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalAccessDetails, T> g) {
        return obj -> g.apply((ExternalAccessDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();
        private Boolean isPublic;
        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();
        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String resourceControlPolicyRestriction;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalAccessDetails model) {
            this.action(model.action);
            this.condition(model.condition);
            this.isPublic(model.isPublic);
            this.principal(model.principal);
            this.sources(model.sources);
            this.resourceControlPolicyRestriction(model.resourceControlPolicyRestriction);
        }

        public final Collection<String> getAction() {
            if (this.action instanceof SdkAutoConstructList) {
                return null;
            }
            return this.action;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String ... action) {
            this.action(Arrays.asList(action));
            return this;
        }

        public final Map<String, String> getCondition() {
            if (this.condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.condition;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final Map<String, String> getPrincipal() {
            if (this.principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.principal;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final List<FindingSource.Builder> getSources() {
            List<FindingSource.Builder> result = FindingSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (FindingSource)((FindingSource.Builder)FindingSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceControlPolicyRestriction() {
            return this.resourceControlPolicyRestriction;
        }

        public final void setResourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
            return this;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction(resourceControlPolicyRestriction == null ? null : resourceControlPolicyRestriction.toString());
            return this;
        }

        public ExternalAccessDetails build() {
            return new ExternalAccessDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalAccessDetails> {
        public Builder action(Collection<String> var1);

        public Builder action(String ... var1);

        public Builder condition(Map<String, String> var1);

        public Builder isPublic(Boolean var1);

        public Builder principal(Map<String, String> var1);

        public Builder sources(Collection<FindingSource> var1);

        public Builder sources(FindingSource ... var1);

        public Builder sources(Consumer<FindingSource.Builder> ... var1);

        public Builder resourceControlPolicyRestriction(String var1);

        public Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction var1);
    }
}

