/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFinding;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse;

public class ValidatePolicyPublisher
implements SdkPublisher<ValidatePolicyResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final ValidatePolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ValidatePolicyPublisher(AccessAnalyzerAsyncClient client, ValidatePolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ValidatePolicyPublisher(AccessAnalyzerAsyncClient client, ValidatePolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ValidatePolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super ValidatePolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ValidatePolicyFinding> findings() {
        Function<ValidatePolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ValidatePolicyResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ValidatePolicyResponseFetcher
    implements AsyncPageFetcher<ValidatePolicyResponse> {
        private ValidatePolicyResponseFetcher() {
        }

        public boolean hasNextPage(ValidatePolicyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ValidatePolicyResponse> nextPage(ValidatePolicyResponse previousPage) {
            if (previousPage == null) {
                return ValidatePolicyPublisher.this.client.validatePolicy(ValidatePolicyPublisher.this.firstRequest);
            }
            return ValidatePolicyPublisher.this.client.validatePolicy((ValidatePolicyRequest)((Object)ValidatePolicyPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

