/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse;

public class ListFindingsPublisher
implements SdkPublisher<ListFindingsResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final ListFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsPublisher(AccessAnalyzerAsyncClient client, ListFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsPublisher(AccessAnalyzerAsyncClient client, ListFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FindingSummary> findings() {
        Function<ListFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFindingsResponseFetcher
    implements AsyncPageFetcher<ListFindingsResponse> {
        private ListFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingsResponse> nextPage(ListFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListFindingsPublisher.this.client.listFindings(ListFindingsPublisher.this.firstRequest);
            }
            return ListFindingsPublisher.this.client.listFindings((ListFindingsRequest)((Object)ListFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

