/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfigurationsMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfigurationsListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.S3PublicAccessBlockConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketConfiguration> {
    private static final SdkField<Map<String, S3AccessPointConfiguration>> ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("accessPoints").getter(S3BucketConfiguration.getter(S3BucketConfiguration::accessPoints)).setter(S3BucketConfiguration.setter(Builder::accessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3AccessPointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<S3BucketAclGrantConfiguration>> BUCKET_ACL_GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bucketAclGrants").getter(S3BucketConfiguration.getter(S3BucketConfiguration::bucketAclGrants)).setter(S3BucketConfiguration.setter(Builder::bucketAclGrants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketAclGrants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3BucketAclGrantConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BUCKET_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketPolicy").getter(S3BucketConfiguration.getter(S3BucketConfiguration::bucketPolicy)).setter(S3BucketConfiguration.setter(Builder::bucketPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPolicy").build()}).build();
    private static final SdkField<S3PublicAccessBlockConfiguration> BUCKET_PUBLIC_ACCESS_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bucketPublicAccessBlock").getter(S3BucketConfiguration.getter(S3BucketConfiguration::bucketPublicAccessBlock)).setter(S3BucketConfiguration.setter(Builder::bucketPublicAccessBlock)).constructor(S3PublicAccessBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPublicAccessBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINTS_FIELD, BUCKET_ACL_GRANTS_FIELD, BUCKET_POLICY_FIELD, BUCKET_PUBLIC_ACCESS_BLOCK_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, S3AccessPointConfiguration> accessPoints;
    private final List<S3BucketAclGrantConfiguration> bucketAclGrants;
    private final String bucketPolicy;
    private final S3PublicAccessBlockConfiguration bucketPublicAccessBlock;

    private S3BucketConfiguration(BuilderImpl builder) {
        this.accessPoints = builder.accessPoints;
        this.bucketAclGrants = builder.bucketAclGrants;
        this.bucketPolicy = builder.bucketPolicy;
        this.bucketPublicAccessBlock = builder.bucketPublicAccessBlock;
    }

    public final boolean hasAccessPoints() {
        return this.accessPoints != null && !(this.accessPoints instanceof SdkAutoConstructMap);
    }

    public final Map<String, S3AccessPointConfiguration> accessPoints() {
        return this.accessPoints;
    }

    public final boolean hasBucketAclGrants() {
        return this.bucketAclGrants != null && !(this.bucketAclGrants instanceof SdkAutoConstructList);
    }

    public final List<S3BucketAclGrantConfiguration> bucketAclGrants() {
        return this.bucketAclGrants;
    }

    public final String bucketPolicy() {
        return this.bucketPolicy;
    }

    public final S3PublicAccessBlockConfiguration bucketPublicAccessBlock() {
        return this.bucketPublicAccessBlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessPoints() ? this.accessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBucketAclGrants() ? this.bucketAclGrants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPublicAccessBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketConfiguration)) {
            return false;
        }
        S3BucketConfiguration other = (S3BucketConfiguration)obj;
        return this.hasAccessPoints() == other.hasAccessPoints() && Objects.equals(this.accessPoints(), other.accessPoints()) && this.hasBucketAclGrants() == other.hasBucketAclGrants() && Objects.equals(this.bucketAclGrants(), other.bucketAclGrants()) && Objects.equals(this.bucketPolicy(), other.bucketPolicy()) && Objects.equals(this.bucketPublicAccessBlock(), other.bucketPublicAccessBlock());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketConfiguration").add("AccessPoints", this.hasAccessPoints() ? this.accessPoints() : null).add("BucketAclGrants", this.hasBucketAclGrants() ? this.bucketAclGrants() : null).add("BucketPolicy", (Object)this.bucketPolicy()).add("BucketPublicAccessBlock", (Object)this.bucketPublicAccessBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPoints": {
                return Optional.ofNullable(clazz.cast(this.accessPoints()));
            }
            case "bucketAclGrants": {
                return Optional.ofNullable(clazz.cast(this.bucketAclGrants()));
            }
            case "bucketPolicy": {
                return Optional.ofNullable(clazz.cast(this.bucketPolicy()));
            }
            case "bucketPublicAccessBlock": {
                return Optional.ofNullable(clazz.cast(this.bucketPublicAccessBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketConfiguration, T> g) {
        return obj -> g.apply((S3BucketConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, S3AccessPointConfiguration> accessPoints = DefaultSdkAutoConstructMap.getInstance();
        private List<S3BucketAclGrantConfiguration> bucketAclGrants = DefaultSdkAutoConstructList.getInstance();
        private String bucketPolicy;
        private S3PublicAccessBlockConfiguration bucketPublicAccessBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketConfiguration model) {
            this.accessPoints(model.accessPoints);
            this.bucketAclGrants(model.bucketAclGrants);
            this.bucketPolicy(model.bucketPolicy);
            this.bucketPublicAccessBlock(model.bucketPublicAccessBlock);
        }

        public final Map<String, S3AccessPointConfiguration.Builder> getAccessPoints() {
            Map<String, S3AccessPointConfiguration.Builder> result = S3AccessPointConfigurationsMapCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Map<String, S3AccessPointConfiguration.BuilderImpl> accessPoints) {
            this.accessPoints = S3AccessPointConfigurationsMapCopier.copyFromBuilder(accessPoints);
        }

        @Override
        @Transient
        public final Builder accessPoints(Map<String, S3AccessPointConfiguration> accessPoints) {
            this.accessPoints = S3AccessPointConfigurationsMapCopier.copy(accessPoints);
            return this;
        }

        public final List<S3BucketAclGrantConfiguration.Builder> getBucketAclGrants() {
            List<S3BucketAclGrantConfiguration.Builder> result = S3BucketAclGrantConfigurationsListCopier.copyToBuilder(this.bucketAclGrants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBucketAclGrants(Collection<S3BucketAclGrantConfiguration.BuilderImpl> bucketAclGrants) {
            this.bucketAclGrants = S3BucketAclGrantConfigurationsListCopier.copyFromBuilder(bucketAclGrants);
        }

        @Override
        @Transient
        public final Builder bucketAclGrants(Collection<S3BucketAclGrantConfiguration> bucketAclGrants) {
            this.bucketAclGrants = S3BucketAclGrantConfigurationsListCopier.copy(bucketAclGrants);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bucketAclGrants(S3BucketAclGrantConfiguration ... bucketAclGrants) {
            this.bucketAclGrants(Arrays.asList(bucketAclGrants));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder bucketAclGrants(Consumer<S3BucketAclGrantConfiguration.Builder> ... bucketAclGrants) {
            this.bucketAclGrants(Stream.of(bucketAclGrants).map(c -> (S3BucketAclGrantConfiguration)((S3BucketAclGrantConfiguration.Builder)S3BucketAclGrantConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBucketPolicy() {
            return this.bucketPolicy;
        }

        public final void setBucketPolicy(String bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
        }

        @Override
        @Transient
        public final Builder bucketPolicy(String bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
            return this;
        }

        public final S3PublicAccessBlockConfiguration.Builder getBucketPublicAccessBlock() {
            return this.bucketPublicAccessBlock != null ? this.bucketPublicAccessBlock.toBuilder() : null;
        }

        public final void setBucketPublicAccessBlock(S3PublicAccessBlockConfiguration.BuilderImpl bucketPublicAccessBlock) {
            this.bucketPublicAccessBlock = bucketPublicAccessBlock != null ? bucketPublicAccessBlock.build() : null;
        }

        @Override
        @Transient
        public final Builder bucketPublicAccessBlock(S3PublicAccessBlockConfiguration bucketPublicAccessBlock) {
            this.bucketPublicAccessBlock = bucketPublicAccessBlock;
            return this;
        }

        public S3BucketConfiguration build() {
            return new S3BucketConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketConfiguration> {
        public Builder accessPoints(Map<String, S3AccessPointConfiguration> var1);

        public Builder bucketAclGrants(Collection<S3BucketAclGrantConfiguration> var1);

        public Builder bucketAclGrants(S3BucketAclGrantConfiguration ... var1);

        public Builder bucketAclGrants(Consumer<S3BucketAclGrantConfiguration.Builder> ... var1);

        public Builder bucketPolicy(String var1);

        public Builder bucketPublicAccessBlock(S3PublicAccessBlockConfiguration var1);

        default public Builder bucketPublicAccessBlock(Consumer<S3PublicAccessBlockConfiguration.Builder> bucketPublicAccessBlock) {
            return this.bucketPublicAccessBlock((S3PublicAccessBlockConfiguration)((S3PublicAccessBlockConfiguration.Builder)S3PublicAccessBlockConfiguration.builder().applyMutation(bucketPublicAccessBlock)).build());
        }
    }
}

