/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the policy generation status and properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyGeneration implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyGeneration.Builder, PolicyGeneration> {
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedOn")
            .getter(getter(PolicyGeneration::completedOn))
            .setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedOn").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(PolicyGeneration::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(PolicyGeneration::principalArn)).setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedOn")
            .getter(getter(PolicyGeneration::startedOn))
            .setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedOn").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PolicyGeneration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_ON_FIELD,
            JOB_ID_FIELD, PRINCIPAL_ARN_FIELD, STARTED_ON_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant completedOn;

    private final String jobId;

    private final String principalArn;

    private final Instant startedOn;

    private final String status;

    private PolicyGeneration(BuilderImpl builder) {
        this.completedOn = builder.completedOn;
        this.jobId = builder.jobId;
        this.principalArn = builder.principalArn;
        this.startedOn = builder.startedOn;
        this.status = builder.status;
    }

    /**
     * <p>
     * A timestamp of when the policy generation was completed.
     * </p>
     * 
     * @return A timestamp of when the policy generation was completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
     * <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used
     * with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
     * </p>
     * 
     * @return The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
     *         <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or
     *         used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The ARN of the IAM entity (user or role) for which you are generating a policy.
     * </p>
     * 
     * @return The ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * A timestamp of when the policy generation started.
     * </p>
     * 
     * @return A timestamp of when the policy generation started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * The status of the policy generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the policy generation request.
     * @see JobStatus
     */
    public final JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the policy generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the policy generation request.
     * @see JobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGeneration)) {
            return false;
        }
        PolicyGeneration other = (PolicyGeneration) obj;
        return Objects.equals(completedOn(), other.completedOn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(principalArn(), other.principalArn()) && Objects.equals(startedOn(), other.startedOn())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyGeneration").add("CompletedOn", completedOn()).add("JobId", jobId())
                .add("PrincipalArn", principalArn()).add("StartedOn", startedOn()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "startedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyGeneration, T> g) {
        return obj -> g.apply((PolicyGeneration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyGeneration> {
        /**
         * <p>
         * A timestamp of when the policy generation was completed.
         * </p>
         * 
         * @param completedOn
         *        A timestamp of when the policy generation was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
         * <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or
         * used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
         * </p>
         * 
         * @param jobId
         *        The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
         *        <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies
         *        or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The ARN of the IAM entity (user or role) for which you are generating a policy.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the IAM entity (user or role) for which you are generating a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * A timestamp of when the policy generation started.
         * </p>
         * 
         * @param startedOn
         *        A timestamp of when the policy generation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * The status of the policy generation request.
         * </p>
         * 
         * @param status
         *        The status of the policy generation request.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the policy generation request.
         * </p>
         * 
         * @param status
         *        The status of the policy generation request.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant completedOn;

        private String jobId;

        private String principalArn;

        private Instant startedOn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGeneration model) {
            completedOn(model.completedOn);
            jobId(model.jobId);
            principalArn(model.principalArn);
            startedOn(model.startedOn);
            status(model.status);
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        @Transient
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        @Transient
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        @Transient
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public PolicyGeneration build() {
            return new PolicyGeneration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
