/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListArchiveRulesResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<ListArchiveRulesResponse.Builder, ListArchiveRulesResponse> {
    private static final SdkField<List<ArchiveRuleSummary>> ARCHIVE_RULES_FIELD = SdkField
            .<List<ArchiveRuleSummary>> builder(MarshallingType.LIST)
            .memberName("archiveRules")
            .getter(getter(ListArchiveRulesResponse::archiveRules))
            .setter(setter(Builder::archiveRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArchiveRuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArchiveRuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListArchiveRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ArchiveRuleSummary> archiveRules;

    private final String nextToken;

    private ListArchiveRulesResponse(BuilderImpl builder) {
        super(builder);
        this.archiveRules = builder.archiveRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ArchiveRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchiveRules() {
        return archiveRules != null && !(archiveRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of archive rules created for the specified analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchiveRules} method.
     * </p>
     * 
     * @return A list of archive rules created for the specified analyzer.
     */
    public final List<ArchiveRuleSummary> archiveRules() {
        return archiveRules;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasArchiveRules() ? archiveRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveRulesResponse)) {
            return false;
        }
        ListArchiveRulesResponse other = (ListArchiveRulesResponse) obj;
        return hasArchiveRules() == other.hasArchiveRules() && Objects.equals(archiveRules(), other.archiveRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListArchiveRulesResponse").add("ArchiveRules", hasArchiveRules() ? archiveRules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "archiveRules":
            return Optional.ofNullable(clazz.cast(archiveRules()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListArchiveRulesResponse, T> g) {
        return obj -> g.apply((ListArchiveRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListArchiveRulesResponse> {
        /**
         * <p>
         * A list of archive rules created for the specified analyzer.
         * </p>
         * 
         * @param archiveRules
         *        A list of archive rules created for the specified analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(Collection<ArchiveRuleSummary> archiveRules);

        /**
         * <p>
         * A list of archive rules created for the specified analyzer.
         * </p>
         * 
         * @param archiveRules
         *        A list of archive rules created for the specified analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(ArchiveRuleSummary... archiveRules);

        /**
         * <p>
         * A list of archive rules created for the specified analyzer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ArchiveRuleSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ArchiveRuleSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ArchiveRuleSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #archiveRules(List<ArchiveRuleSummary>)}.
         * 
         * @param archiveRules
         *        a consumer that will call methods on {@link List<ArchiveRuleSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveRules(List<ArchiveRuleSummary>)
         */
        Builder archiveRules(Consumer<ArchiveRuleSummary.Builder>... archiveRules);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private List<ArchiveRuleSummary> archiveRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchiveRulesResponse model) {
            super(model);
            archiveRules(model.archiveRules);
            nextToken(model.nextToken);
        }

        public final List<ArchiveRuleSummary.Builder> getArchiveRules() {
            List<ArchiveRuleSummary.Builder> result = ArchiveRulesListCopier.copyToBuilder(this.archiveRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArchiveRules(Collection<ArchiveRuleSummary.BuilderImpl> archiveRules) {
            this.archiveRules = ArchiveRulesListCopier.copyFromBuilder(archiveRules);
        }

        @Override
        @Transient
        public final Builder archiveRules(Collection<ArchiveRuleSummary> archiveRules) {
            this.archiveRules = ArchiveRulesListCopier.copy(archiveRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder archiveRules(ArchiveRuleSummary... archiveRules) {
            archiveRules(Arrays.asList(archiveRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder archiveRules(Consumer<ArchiveRuleSummary.Builder>... archiveRules) {
            archiveRules(Stream.of(archiveRules).map(c -> ArchiveRuleSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListArchiveRulesResponse build() {
            return new ListArchiveRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
