/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveRuleResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<GetArchiveRuleResponse.Builder, GetArchiveRuleResponse> {
    private static final SdkField<ArchiveRuleSummary> ARCHIVE_RULE_FIELD = SdkField
            .<ArchiveRuleSummary> builder(MarshallingType.SDK_POJO).memberName("archiveRule")
            .getter(getter(GetArchiveRuleResponse::archiveRule)).setter(setter(Builder::archiveRule))
            .constructor(ArchiveRuleSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_RULE_FIELD));

    private final ArchiveRuleSummary archiveRule;

    private GetArchiveRuleResponse(BuilderImpl builder) {
        super(builder);
        this.archiveRule = builder.archiveRule;
    }

    /**
     * Returns the value of the ArchiveRule property for this object.
     * 
     * @return The value of the ArchiveRule property for this object.
     */
    public final ArchiveRuleSummary archiveRule() {
        return archiveRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveRuleResponse)) {
            return false;
        }
        GetArchiveRuleResponse other = (GetArchiveRuleResponse) obj;
        return Objects.equals(archiveRule(), other.archiveRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveRuleResponse").add("ArchiveRule", archiveRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "archiveRule":
            return Optional.ofNullable(clazz.cast(archiveRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveRuleResponse, T> g) {
        return obj -> g.apply((GetArchiveRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetArchiveRuleResponse> {
        /**
         * Sets the value of the ArchiveRule property for this object.
         *
         * @param archiveRule
         *        The new value for the ArchiveRule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRule(ArchiveRuleSummary archiveRule);

        /**
         * Sets the value of the ArchiveRule property for this object.
         *
         * This is a convenience that creates an instance of the {@link ArchiveRuleSummary.Builder} avoiding the need to
         * create one manually via {@link ArchiveRuleSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArchiveRuleSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #archiveRule(ArchiveRuleSummary)}.
         * 
         * @param archiveRule
         *        a consumer that will call methods on {@link ArchiveRuleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveRule(ArchiveRuleSummary)
         */
        default Builder archiveRule(Consumer<ArchiveRuleSummary.Builder> archiveRule) {
            return archiveRule(ArchiveRuleSummary.builder().applyMutation(archiveRule).build());
        }
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private ArchiveRuleSummary archiveRule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveRuleResponse model) {
            super(model);
            archiveRule(model.archiveRule);
        }

        public final ArchiveRuleSummary.Builder getArchiveRule() {
            return archiveRule != null ? archiveRule.toBuilder() : null;
        }

        public final void setArchiveRule(ArchiveRuleSummary.BuilderImpl archiveRule) {
            this.archiveRule = archiveRule != null ? archiveRule.build() : null;
        }

        @Override
        @Transient
        public final Builder archiveRule(ArchiveRuleSummary archiveRule) {
            this.archiveRule = archiveRule;
            return this;
        }

        @Override
        public GetArchiveRuleResponse build() {
            return new GetArchiveRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
