/*
 * Decompiled with CFR 0.152.
 */
package si.uom;

import java.util.Set;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import si.uom.SI;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.IonizingRadiation;
import si.uom.quantity.KinematicViscosity;
import si.uom.quantity.Luminance;
import si.uom.quantity.MagneticFieldStrength;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

public final class NonSI
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Non-SI Units";
    private static final int STANDARD_GRAVITY_DIVIDEND = 980665;
    private static final int STANDARD_GRAVITY_DIVISOR = 100000;
    private static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    private static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final double AVOGADRO_CONSTANT = 6.02214199E23;
    private static final double ELEMENTARY_CHARGE = 1.602176462E-19;
    private static final NonSI INSTANCE = new NonSI();
    public static final Unit<Angle> DEGREE_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 180L))), "Degree Angle", "deg");
    public static final Unit<Angle> MINUTE_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 10800L))), "Minute Angle", "'");
    public static final Unit<Angle> SECOND_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate((AbstractConverter)new RationalConverter(1L, 648000L))), "Second Angle", "''");
    public static final Unit<Mass> TONNE = AbstractSystemOfUnits.Helper.addUnit((Set)NonSI.INSTANCE.units, (Unit)new TransformedUnit(Units.KILOGRAM, (UnitConverter)new RationalConverter(1000L, 1L)), (String)"Tonne", (String)"t");
    public static final Unit<Energy> ELECTRON_VOLT = NonSI.addUnit(new TransformedUnit(Units.JOULE, (UnitConverter)new MultiplyConverter(1.602176487E-19)), "Electron Volt", "eV");
    public static final Unit<Mass> UNIFIED_ATOMIC_MASS = NonSI.addUnit(new TransformedUnit(Units.KILOGRAM, (UnitConverter)new MultiplyConverter(1.660538782E-27)), "Unified atomic mass", "u", true);
    public static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.addUnit(new TransformedUnit(Units.METRE, (UnitConverter)new MultiplyConverter(1.49597871E11)), "Astronomical Unit", "UA");
    public static final Unit<Area> HECTARE = NonSI.addUnit(new TransformedUnit(Units.SQUARE_METRE, (UnitConverter)new RationalConverter(10000L, 1L)), "Hectare", "ha");
    public static final Unit<Dimensionless> PI = NonSI.addUnit(AbstractUnit.ONE.multiply(Math.PI));
    public static final Unit<AmountOfSubstance> ATOM = NonSI.addUnit(Units.MOLE.divide(6.02214199E23));
    public static final Unit<Length> ANGSTROM = NonSI.addUnit(Units.METRE.divide(1.0E10), "\u00c5ngstr\u00f6m", "\u00c5");
    public static final Unit<Length> LIGHT_YEAR = NonSI.addUnit(Units.METRE.multiply(9.460528405E15), "Light year", "ly");
    public static final Unit<Length> PARSEC = NonSI.addUnit(Units.METRE.multiply(3.085677E16));
    public static final Unit<Length> NAUTICAL_MILE = NonSI.addUnit(Units.METRE.multiply(1852.0), "Nautical mile", "nmi");
    public static final Unit<Area> BARN = NonSI.addUnit(new ProductUnit(MetricPrefix.FEMTO((Unit)Units.METRE).pow(2)).multiply(100.0));
    public static final Unit<Time> DAY_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(86164.09));
    public static final Unit<Time> YEAR_CALENDAR = NonSI.addUnit(Units.DAY.multiply(365.0));
    public static final Unit<Time> YEAR_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(3.155814954E7));
    public static final Unit<Time> YEAR_JULIEN = NonSI.addUnit(Units.SECOND.multiply(3.15576E7));
    protected static final Unit<Mass> ATOMIC_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(1.6605387280149467E-27));
    protected static final Unit<Mass> ELECTRON_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(9.10938188E-31));
    protected static final Unit<Mass> POUND = NonSI.addUnit(Units.KILOGRAM.multiply(4.5359237E7).divide(1.0E8));
    protected static final Unit<ElectricCharge> E = NonSI.addUnit(Units.COULOMB.multiply(1.602176462E-19));
    protected static final Unit<ElectricCharge> FARADAY = NonSI.addUnit(Units.COULOMB.multiply(96485.3414719984));
    protected static final Unit<ElectricCharge> FRANKLIN = NonSI.addUnit(Units.COULOMB.multiply(3.3356E-10));
    protected static final Unit<Temperature> RANKINE = NonSI.addUnit(Units.KELVIN.multiply(5.0).divide(9.0));
    public static final Unit<Angle> REVOLUTION = NonSI.addUnit(Units.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class));
    protected static final Unit<Speed> C = NonSI.addUnit(Units.METRE_PER_SECOND.multiply(2.99792458E8));
    public static final Unit<Speed> KNOT = NonSI.addUnit(NAUTICAL_MILE.divide(Units.HOUR).asType(Speed.class), "Knot", "kn");
    protected static final Unit<Acceleration> G = NonSI.addUnit(Units.METRE_PER_SQUARE_SECOND.multiply(980665.0).divide(100000.0));
    public static final Unit<Acceleration> GAL = NonSI.addUnit(new ProductUnit(MetricPrefix.CENTI((Unit)Units.METRE).divide(Units.SECOND.pow(2))));
    protected static final Unit<Area> ARE = NonSI.addUnit(Units.SQUARE_METRE.multiply(100.0));
    protected static final Unit<ElectricCurrent> GILBERT = NonSI.addUnit(Units.AMPERE.multiply(10.0).divide(4.0).multiply(PI).asType(ElectricCurrent.class));
    public static final Unit<Energy> ERG = NonSI.addUnit(Units.JOULE.divide(1.0E7));
    public static final Unit<Luminance> STILB = NonSI.addUnit(new ProductUnit(Units.CANDELA.divide(MetricPrefix.CENTI((Unit)Units.METRE).pow(2))));
    protected static final Unit<Luminance> LAMBERT = NonSI.addUnit(new ProductUnit(STILB.divide(PI)));
    public static final Unit<Illuminance> PHOT = NonSI.addUnit(Units.LUX.divide(10000.0), "Phot", "ph");
    public static final Unit<MagneticFlux> MAXWELL = NonSI.addUnit(Units.WEBER.divide(1.0E8));
    public static final Unit<MagneticFluxDensity> GAUSS = NonSI.addUnit(Units.TESLA.divide(10000.0));
    public static final Unit<MagneticFieldStrength> OERSTED = NonSI.addUnit(new ProductUnit(SI.AMPERE_PER_METRE.multiply(250.0).divide(PI)), "\u00d8rsted", "Oe", true);
    public static final Unit<Force> DYNE = NonSI.addUnit(Units.NEWTON.divide(100000.0), "Dyne", "dyn", true);
    protected static final Unit<Force> KILOGRAM_FORCE = NonSI.addUnit(Units.NEWTON.multiply(980665.0).divide(100000.0));
    protected static final Unit<Force> POUND_FORCE = NonSI.addUnit(Units.NEWTON.multiply(4.4482216152605E13).divide(1.0E13));
    protected static final Unit<Power> HORSEPOWER = NonSI.addUnit(Units.WATT.multiply(735.499));
    public static final Unit<Pressure> BAR = NonSI.addUnit(Units.PASCAL.multiply(100000.0));
    public static final Unit<Pressure> MILLIMETRE_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(133.322));
    public static final Unit<Pressure> INCH_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(3386.388));
    public static final Unit<RadiationDoseAbsorbed> RAD = NonSI.addUnit(Units.GRAY.divide(100.0));
    public static final Unit<RadiationDoseEffective> REM = NonSI.addUnit(Units.SIEVERT.divide(100.0));
    protected static final Unit<Radioactivity> CURIE = NonSI.addUnit(Units.BECQUEREL.multiply(3.7E10));
    protected static final Unit<Radioactivity> RUTHERFORD = NonSI.addUnit(Units.BECQUEREL.multiply(1000000.0));
    protected static final Unit<SolidAngle> SPHERE = NonSI.addUnit(Units.STERADIAN.multiply(4.0).multiply(PI).asType(SolidAngle.class));
    public static final Unit<DynamicViscosity> POISE = NonSI.addUnit(Units.GRAM.divide(MetricPrefix.CENTI((Unit)Units.METRE).multiply(Units.SECOND))).asType(DynamicViscosity.class);
    public static final Unit<KinematicViscosity> STOKES = NonSI.addUnit(MetricPrefix.CENTI((Unit)Units.METRE).pow(2).divide(Units.SECOND)).asType(KinematicViscosity.class);
    protected static final Unit<Frequency> FRAMES_PER_SECOND = NonSI.addUnit(AbstractUnit.ONE.divide(Units.SECOND)).asType(Frequency.class);
    public static final Unit<IonizingRadiation> ROENTGEN = NonSI.addUnit(Units.COULOMB.divide(Units.KILOGRAM).multiply(2.58E-4), "Roentgen", "R", true);

    private NonSI() {
    }

    public static NonSI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)NonSI.INSTANCE.units, unit, (String)name);
        }
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return NonSI.addUnit(unit, name, text, true);
    }

    static {
        SimpleUnitFormat.getInstance().label(TONNE, "t");
        SimpleUnitFormat.getInstance().label(MetricPrefix.MEGA(TONNE), "Mt");
    }
}

