/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.utils;

import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Severity;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.allure.config.AllureModelUtils;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteStartedEvent;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.SeverityLevel;

public class AnnotationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationManager.class);
    private Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
    private static String Hostname = null;

    public AnnotationManager(Collection<Annotation> annotations) {
        this.populateAnnotations(annotations);
    }

    public AnnotationManager(Annotation ... annotations) {
        this.populateAnnotations(Arrays.asList(annotations));
    }

    private void populateAnnotations(Collection<Annotation> annotations) {
        for (Annotation each : annotations) {
            this.annotations.put(each.annotationType(), each);
        }
    }

    public void setDefaults(Annotation[] defaultAnnotations) {
        if (defaultAnnotations == null) {
            return;
        }
        for (Annotation each : defaultAnnotations) {
            Class<? extends Annotation> key = each.annotationType();
            if (Title.class.equals(key) || Description.class.equals(key) || this.annotations.containsKey(key)) continue;
            this.annotations.put(key, each);
        }
    }

    private static String getHostname() {
        if (Hostname == null) {
            try {
                Hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                Hostname = "default";
                LOGGER.warn("Can not get current hostname", (Throwable)e);
            }
        }
        return Hostname;
    }

    public void update(TestSuiteStartedEvent event) {
        if (this.isTitleAnnotationPresent()) {
            event.setTitle(this.getTitle());
        }
        if (this.isDescriptionAnnotationPresent()) {
            event.setDescription(this.getDescription());
        }
        if (this.isIssueAnnotationPresent()) {
            event.getLabels().add(AllureModelUtils.createIssueLabel((String)this.getIssueKey()));
        }
        if (this.isIssuesAnnotationPresent()) {
            for (String issueKey : this.getIssueKeys()) {
                event.getLabels().add(AllureModelUtils.createIssueLabel((String)issueKey));
            }
        }
        event.getLabels().addAll(this.getStoryLabels());
        event.getLabels().addAll(this.getFeatureLabels());
    }

    public void update(TestCaseStartedEvent event) {
        if (this.isTitleAnnotationPresent()) {
            event.setTitle(this.getTitle());
        }
        if (this.isDescriptionAnnotationPresent()) {
            event.setDescription(this.getDescription());
        }
        if (this.isSeverityAnnotationPresent()) {
            event.getLabels().add(AllureModelUtils.createSeverityLabel((SeverityLevel)this.getSeverity()));
        }
        if (this.isIssueAnnotationPresent()) {
            event.getLabels().add(AllureModelUtils.createIssueLabel((String)this.getIssueKey()));
        }
        if (this.isIssuesAnnotationPresent()) {
            for (String issueKey : this.getIssueKeys()) {
                event.getLabels().add(AllureModelUtils.createIssueLabel((String)issueKey));
            }
        }
        if (this.isTestCaseIdAnnotationPresent()) {
            event.getLabels().add(AllureModelUtils.createTestLabel((String)this.getTestCaseId()));
        }
        event.getLabels().addAll(this.getStoryLabels());
        event.getLabels().addAll(this.getFeatureLabels());
        AnnotationManager.withExecutorInfo(event);
    }

    public static TestCaseStartedEvent withExecutorInfo(TestCaseStartedEvent event) {
        event.getLabels().add(AllureModelUtils.createHostLabel((String)AnnotationManager.getHostname()));
        event.getLabels().add(AllureModelUtils.createThreadLabel((String)String.format("%s.%s(%s)", ManagementFactory.getRuntimeMXBean().getName(), Thread.currentThread().getName(), Thread.currentThread().getId())));
        return event;
    }

    public boolean isTitleAnnotationPresent() {
        return this.isAnnotationPresent(Title.class);
    }

    public boolean isDescriptionAnnotationPresent() {
        return this.isAnnotationPresent(Description.class);
    }

    public boolean isSeverityAnnotationPresent() {
        return this.isAnnotationPresent(Severity.class);
    }

    public boolean isStoriesAnnotationPresent() {
        return this.isAnnotationPresent(Stories.class);
    }

    public boolean isFeaturesAnnotationPresent() {
        return this.isAnnotationPresent(Features.class);
    }

    public boolean isIssuesAnnotationPresent() {
        return this.isAnnotationPresent(Issues.class);
    }

    public boolean isIssueAnnotationPresent() {
        return this.isAnnotationPresent(Issue.class);
    }

    public boolean isTestCaseIdAnnotationPresent() {
        return this.isAnnotationPresent(TestCaseId.class);
    }

    public String getTitle() {
        Title title = this.getAnnotation(Title.class);
        return title == null ? null : title.value();
    }

    public ru.yandex.qatools.allure.model.Description getDescription() {
        Description description = this.getAnnotation(Description.class);
        return description == null ? null : new ru.yandex.qatools.allure.model.Description().withValue(description.value()).withType(description.type());
    }

    public SeverityLevel getSeverity() {
        Severity severity = this.getAnnotation(Severity.class);
        return severity == null ? null : severity.value();
    }

    public String getIssueKey() {
        Issue issue = this.getAnnotation(Issue.class);
        return issue == null ? null : issue.value();
    }

    private String getTestCaseId() {
        TestCaseId testCaseId = this.getAnnotation(TestCaseId.class);
        return testCaseId == null ? null : testCaseId.value();
    }

    public List<Label> getStoryLabels() {
        if (!this.isAnnotationPresent(Stories.class)) {
            return Collections.emptyList();
        }
        ArrayList<Label> result = new ArrayList<Label>();
        for (String story : this.getAnnotation(Stories.class).value()) {
            result.add(AllureModelUtils.createStoryLabel((String)story));
        }
        return result;
    }

    public List<Label> getFeatureLabels() {
        if (!this.isAnnotationPresent(Features.class)) {
            return Collections.emptyList();
        }
        ArrayList<Label> result = new ArrayList<Label>();
        for (String feature : this.getAnnotation(Features.class).value()) {
            result.add(AllureModelUtils.createFeatureLabel((String)feature));
        }
        return result;
    }

    public String[] getIssueKeys() {
        Issues issues = this.getAnnotation(Issues.class);
        if (issues == null) {
            return new String[0];
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Issue issue : issues.value()) {
            keys.add(issue.value());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        return this.annotations.containsKey(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        Annotation value = this.annotations.get(annotationType);
        return (T)((Annotation)annotationType.cast(value));
    }
}

