/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.precis.PrecisProfile;
import rocks.xmpp.precis.PrecisProfiles;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsernameCaseMappedProfileTest {
    @Test
    public void testAllowedStrings() {
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"juliet@example.com"), (String)"juliet@example.com");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"fussball"), (String)"fussball");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"fu\u00dfball"), (String)"fu\u00dfball");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u03c0"), (String)"\u03c0");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u03a3"), (String)"\u03c3");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u03c3"), (String)"\u03c3");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u03c2"), (String)"\u03c2");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"I"), (String)"i");
        Assert.assertEquals((String)PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u03b0"), (String)"\u03b0");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSpaceCharacters() {
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"foo bar");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRomanFour() {
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"henry\u2163");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInfinity() {
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u221e");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testBlackChessKing() {
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u265a");
    }

    @Test
    public void testLetterDigits() {
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"~");
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"a");
    }

    @Test
    public void testPrintableCharacters() {
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"!");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSpaceCharacters1() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)" ");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSpaceCharacters2() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\t");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSpaceCharacters3() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\n");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSymbolCharacters1() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u2600");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSymbolCharacters2() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u26d6");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSymbolCharacters3() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u26ff");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCompatibilityEquivalent() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\ufb00");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOtherLetterDigits1() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u01c5");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOtherLetterDigits2() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u16ee");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOtherLetterDigits3() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u00b2");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOtherLetterDigits4() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u0488");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptyUsername() {
        PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"");
    }

    @Test
    public void testCompositeCharactersAndCombiningSequence() {
        String ang = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u212b");
        String a = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"A\u030a");
        String b = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u00c5");
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((Object)a, (Object)ang);
        String c = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"c\u0327");
        String d = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u00e7");
        Assert.assertEquals((Object)c, (Object)d);
        String e = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"R\u030c");
        String f = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u0158");
        Assert.assertEquals((Object)e, (Object)f);
    }

    @Test
    public void testConfusableCharacters() {
        String a = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"A");
        String b = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u0410");
        Assert.assertNotEquals((Object)a, (Object)b);
    }

    @Test
    public void testWidthMapping() {
        String a = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\uff21\uff22");
        String b = PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"ab");
        Assert.assertEquals((Object)a, (Object)b);
    }

    @Test(enabled=false)
    public void testPerformance() {
        int n = 1000000;
        long c = 0L;
        for (int i = 0; i < n; ++i) {
            long nano = System.nanoTime();
            PrecisProfiles.USERNAME_CASE_MAPPED.enforce((CharSequence)"\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4\u00e4");
            c += System.nanoTime() - nano;
        }
        System.out.println(c / (long)n);
    }

    @Test
    public void testIdempotencyEnforcement() {
        UsernameCaseMappedProfileTest.testIdempotency(arg_0 -> ((PrecisProfile)PrecisProfiles.USERNAME_CASE_MAPPED).enforce(arg_0));
    }

    static void testIdempotency(Function<CharSequence, String> rules) {
        for (int cp = 0; cp < 0x10FFFF; ++cp) {
            String input = new String(Character.toChars(cp));
            try {
                String applied = rules.apply(input);
                String applied2 = rules.apply(applied);
                Assert.assertEquals((String)applied, (String)applied2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

