/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.precis.PrecisProfile;
import rocks.xmpp.precis.PrecisProfiles;

public class IdentifierClassTest {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldNotAllowNonCharacter() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\ufdd0");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldNotAllowOldHangulJamoCharacters() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\ua960");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldNotAllowIgnorableCharacters() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u034f");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldNotAllowControlCharacters() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u061c");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldNotAllowSymbols() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u265a");
    }

    @Test
    public void testHasCompat() {
        Assert.assertTrue((boolean)PrecisProfile.hasCompatibilityEquivalent((int)8547));
    }

    @Test
    public void shouldBeExceptionallyValid() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u03c2\u00df");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldBeExceptionallyDisallowed() {
        PrecisProfiles.USERNAME_CASE_MAPPED.prepare((CharSequence)"\u3032");
    }

    @Test
    public void testUnassigned() {
        Assert.assertTrue((boolean)PrecisProfile.isUnassigned((int)8293));
        Assert.assertTrue((boolean)PrecisProfile.isUnassigned((int)1535));
        Assert.assertFalse((boolean)PrecisProfile.isUnassigned((int)65535));
        Assert.assertFalse((boolean)PrecisProfile.isUnassigned((int)64976));
    }
}

