/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.precis.PrecisProfiles;

public class IDNProfileTest {
    @Test
    public void testDots() {
        String domainName = PrecisProfiles.IDN.enforce((CharSequence)"a\u3002b\uff0ec\uff61d");
        Assert.assertEquals((String)domainName, (String)"a.b.c.d");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNonLDHAsciiCharacters() {
        PrecisProfiles.IDN.enforce((CharSequence)"_test");
    }

    @Test
    public void testUnicodeDomain() {
        String domainName = PrecisProfiles.IDN.enforce((CharSequence)"\u010dechy.example");
        Assert.assertEquals((String)domainName, (String)"\u010dechy.example");
    }

    @Test
    public void testAsciiDomain() {
        String domainName = PrecisProfiles.IDN.enforce((CharSequence)"xn--dmin-moa0i");
        Assert.assertEquals((String)domainName, (String)"d\u00f6m\u00e4in");
        domainName = PrecisProfiles.IDN.enforce((CharSequence)"xn--xample-2of.com");
        Assert.assertEquals((String)domainName, (String)"\u0435xample.com");
    }

    @Test
    public void testCaseMapping() {
        String domainName = PrecisProfiles.IDN.enforce((CharSequence)"DOMAIN");
        Assert.assertEquals((String)domainName, (String)"domain");
    }
}

