/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import java.text.Normalizer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import rocks.xmpp.precis.InvalidCodePointException;
import rocks.xmpp.precis.InvalidDirectionalityException;

public abstract class PrecisProfile
implements Comparator<CharSequence> {
    private static final Map<Character, Character> WIDTH_MAP;
    private static final int EN_ES_CS_ET_ON_BN_NSM = 9144;
    private static final int L_EN_ES_CS_ET_ON_BN_NSM = 9145;
    private static final int R_AL_AN_EN_ES_CS_ET_ON_BN_NSM = 9214;
    private static final int EN_AN = 72;
    static final Pattern WHITESPACE;
    private final boolean identifierClass;

    protected PrecisProfile(boolean identifierClass) {
        this.identifierClass = identifierClass;
    }

    private static boolean isLetterDigit(int cp) {
        return (886 >> Character.getType(cp) & 1) != 0;
    }

    private static boolean isExceptionallyValid(int cp) {
        return cp == 223 || cp == 962 || cp == 1789 || cp == 1790 || cp == 3851 || cp == 12295;
    }

    private static boolean isExceptionallyDisallowed(int cp) {
        return cp == 1600 || cp == 2042 || cp == 12334 || cp == 12335 || cp >= 12337 && cp <= 12341 || cp == 12347;
    }

    private static boolean isBackwardsCompatible(int cp) {
        return false;
    }

    private static boolean isJoinControl(int cp) {
        return cp == 8204 || cp == 8205;
    }

    private static boolean isOldHangulJamo(int cp) {
        return cp >= 4352 && cp <= 4607 || cp >= 43360 && cp <= 43391 || cp >= 55216 && cp <= 55295;
    }

    static boolean isUnassigned(int cp) {
        return !Character.isDefined(cp) && !PrecisProfile.isNonCharacter(cp);
    }

    private static boolean isASCII7(int cp) {
        return cp >= 33 && cp <= 126;
    }

    private static boolean isControl(int cp) {
        return Character.isISOControl(cp);
    }

    private static boolean isDefaultIgnorable(int cp) {
        return cp == 173 || cp == 847 || cp == 1564 || cp >= 4447 && cp <= 4448 || cp >= 6068 && cp <= 6069 || cp >= 6155 && cp <= 6158 || cp >= 8203 && cp <= 8207 || cp >= 8234 && cp <= 8238 || cp >= 8288 && cp <= 8303 || cp == 12644 || cp >= 65024 && cp <= 65039 || cp == 65279 || cp == 65440 || cp >= 65520 && cp <= 65528;
    }

    private static boolean isNonCharacter(int cp) {
        return cp >= 64976 && cp <= 65007 || cp >= 65534 && cp <= 65535;
    }

    private static boolean isIgnorable(int cp) {
        return PrecisProfile.isDefaultIgnorable(cp) || PrecisProfile.isNonCharacter(cp);
    }

    private static boolean isSpace(int cp) {
        return (4096 >> Character.getType(cp) & 1) != 0;
    }

    private static boolean isSymbol(int cp) {
        return (0x1E000000 >> Character.getType(cp) & 1) != 0;
    }

    private static boolean isPunctuation(int cp) {
        return (1643118592 >> Character.getType(cp) & 1) != 0;
    }

    static boolean hasCompatibilityEquivalent(int cp) {
        String s = new String(new int[]{cp}, 0, 1);
        return !Normalizer.isNormalized(s, Normalizer.Form.NFKC);
    }

    private static boolean isOtherLetterDigit(int cp) {
        return (3208 >> Character.getType(cp) & 1) != 0;
    }

    protected static CharSequence widthMap(CharSequence s) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < s.length(); ++i) {
            Character c = WIDTH_MAP.get(Character.valueOf(s.charAt(i)));
            if (c == null) continue;
            sb.setCharAt(i, c.charValue());
        }
        return sb;
    }

    protected static CharSequence caseFold(CharSequence input) {
        return input.toString().toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    protected static void checkBidiRule(CharSequence label) {
        byte directionalityLastNonNSMCharacter;
        boolean isRTLLabel;
        if (label == null) {
            return;
        }
        if (label.length() == 0) {
            return;
        }
        int i = 0;
        int cp = Character.codePointAt(label, i);
        i += Character.charCount(cp);
        byte dir1stChar = Character.getDirectionality(cp);
        boolean isLTRLabel = dir1stChar == 0;
        boolean bl = isRTLLabel = dir1stChar == 1 || dir1stChar == 2;
        if (!isLTRLabel && !isRTLLabel) {
            throw new InvalidDirectionalityException("Bidi Rule 1: The first character must be a character with Bidi property L, R or AL.");
        }
        int length = label.length();
        while ((directionalityLastNonNSMCharacter = Character.getDirectionality(cp = Character.codePointBefore(label, length))) == 8 && (length -= Character.charCount(cp)) > 0) {
        }
        int directionalityMask = 0;
        while (i < length + 1) {
            cp = Character.codePointAt(label, i);
            i += Character.charCount(cp);
            directionalityMask |= 1 << Character.getDirectionality(cp);
        }
        if (isRTLLabel) {
            if ((directionalityMask & 0xFFFFDC01) != 0) {
                throw new InvalidDirectionalityException("Bidi Rule 2: In an RTL label, only characters with the Bidi properties R, AL, AN, EN, ES, CS, ET, ON, BN, or NSM are allowed.");
            }
            if (directionalityLastNonNSMCharacter != 1 && directionalityLastNonNSMCharacter != 2 && directionalityLastNonNSMCharacter != 3 && directionalityLastNonNSMCharacter != 6) {
                throw new InvalidDirectionalityException("Bidi Rule 3: In an RTL label, the end of the label must be a character with Bidi property R, AL, EN, or AN.");
            }
            if ((directionalityMask & 0x48) == 72) {
                throw new InvalidDirectionalityException("Bidi Rule 4: In an RTL label, if an EN is present, no AN may be present, and vice versa.");
            }
        } else {
            if ((directionalityMask & 0xFFFFDC46) != 0) {
                throw new InvalidDirectionalityException("Bidi Rule 5: In an LTR label, only characters with the Bidi properties L, EN, ES, CS, ET, ON, BN, or NSM are allowed.");
            }
            if (directionalityLastNonNSMCharacter != 0 && directionalityLastNonNSMCharacter != 3) {
                throw new InvalidDirectionalityException("Bidi Rule 6: In an LTR label, the end of the label must be a character with Bidi property L or EN.");
            }
        }
    }

    public String prepare(CharSequence input) {
        int codePoint;
        int length = input.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(input, offset);
            boolean valid = false;
            if (PrecisProfile.isExceptionallyValid(codePoint)) {
                valid = true;
            } else if (PrecisProfile.isExceptionallyDisallowed(codePoint)) {
                valid = false;
            } else if (PrecisProfile.isBackwardsCompatible(codePoint)) {
                valid = true;
            } else if (PrecisProfile.isUnassigned(codePoint)) {
                valid = false;
            } else if (PrecisProfile.isASCII7(codePoint)) {
                valid = true;
            } else if (PrecisProfile.isJoinControl(codePoint)) {
                valid = false;
            } else if (PrecisProfile.isOldHangulJamo(codePoint)) {
                valid = false;
            } else if (PrecisProfile.isIgnorable(codePoint)) {
                valid = false;
            } else if (PrecisProfile.isControl(codePoint)) {
                valid = false;
            } else if (PrecisProfile.hasCompatibilityEquivalent(codePoint)) {
                valid = !this.identifierClass;
            } else if (PrecisProfile.isLetterDigit(codePoint)) {
                valid = true;
            } else if (PrecisProfile.isOtherLetterDigit(codePoint)) {
                valid = !this.identifierClass;
            } else if (PrecisProfile.isSpace(codePoint)) {
                valid = !this.identifierClass;
            } else if (PrecisProfile.isSymbol(codePoint)) {
                valid = !this.identifierClass;
            } else if (PrecisProfile.isPunctuation(codePoint)) {
                boolean bl = valid = !this.identifierClass;
            }
            if (valid) continue;
            throw new InvalidCodePointException("Invalid code point at position " + offset + ": 0x" + Integer.toHexString(codePoint));
        }
        return input.toString();
    }

    public String enforce(CharSequence input) {
        return this.prepare(this.applyDirectionalityRule(this.applyNormalizationRule(this.applyCaseMappingRule(this.applyAdditionalMappingRule(this.applyWidthMappingRule(input))))));
    }

    @Override
    public int compare(CharSequence o1, CharSequence o2) {
        return this.enforce(o1).compareTo(this.enforce(o2));
    }

    protected abstract CharSequence applyWidthMappingRule(CharSequence var1);

    protected abstract CharSequence applyAdditionalMappingRule(CharSequence var1);

    protected abstract CharSequence applyCaseMappingRule(CharSequence var1);

    protected abstract CharSequence applyNormalizationRule(CharSequence var1);

    protected abstract CharSequence applyDirectionalityRule(CharSequence var1);

    static {
        char mapping;
        char c;
        WIDTH_MAP = new HashMap<Character, Character>();
        WHITESPACE = Pattern.compile("\\p{Zs}");
        for (c = '\uff01'; c <= '\uff5e'; c = (char)(c + '\u0001')) {
            mapping = (char)(c - 65248);
            WIDTH_MAP.put(Character.valueOf(c), Character.valueOf(mapping));
        }
        WIDTH_MAP.put(Character.valueOf('\uff5f'), Character.valueOf('\u2985'));
        WIDTH_MAP.put(Character.valueOf('\uff60'), Character.valueOf('\u2986'));
        WIDTH_MAP.put(Character.valueOf('\uff61'), Character.valueOf('\u3002'));
        WIDTH_MAP.put(Character.valueOf('\uff62'), Character.valueOf('\u300c'));
        WIDTH_MAP.put(Character.valueOf('\uff63'), Character.valueOf('\u300d'));
        WIDTH_MAP.put(Character.valueOf('\uff64'), Character.valueOf('\u3001'));
        WIDTH_MAP.put(Character.valueOf('\uff65'), Character.valueOf('\u30fb'));
        WIDTH_MAP.put(Character.valueOf('\uff66'), Character.valueOf('\u30f2'));
        WIDTH_MAP.put(Character.valueOf('\uff67'), Character.valueOf('\u30a1'));
        WIDTH_MAP.put(Character.valueOf('\uff68'), Character.valueOf('\u30a3'));
        WIDTH_MAP.put(Character.valueOf('\uff69'), Character.valueOf('\u30a5'));
        WIDTH_MAP.put(Character.valueOf('\uff6a'), Character.valueOf('\u30a7'));
        WIDTH_MAP.put(Character.valueOf('\uff6b'), Character.valueOf('\u30a9'));
        WIDTH_MAP.put(Character.valueOf('\uff6c'), Character.valueOf('\u30e3'));
        WIDTH_MAP.put(Character.valueOf('\uff6d'), Character.valueOf('\u30e5'));
        WIDTH_MAP.put(Character.valueOf('\uff6e'), Character.valueOf('\u30e7'));
        WIDTH_MAP.put(Character.valueOf('\uff6f'), Character.valueOf('\u30c3'));
        WIDTH_MAP.put(Character.valueOf('\uff70'), Character.valueOf('\u30fc'));
        WIDTH_MAP.put(Character.valueOf('\uff71'), Character.valueOf('\u30a2'));
        WIDTH_MAP.put(Character.valueOf('\uff72'), Character.valueOf('\u30a4'));
        WIDTH_MAP.put(Character.valueOf('\uff73'), Character.valueOf('\u30a6'));
        WIDTH_MAP.put(Character.valueOf('\uff74'), Character.valueOf('\u30a8'));
        WIDTH_MAP.put(Character.valueOf('\uff75'), Character.valueOf('\u30aa'));
        WIDTH_MAP.put(Character.valueOf('\uff76'), Character.valueOf('\u30ab'));
        WIDTH_MAP.put(Character.valueOf('\uff77'), Character.valueOf('\u30ad'));
        WIDTH_MAP.put(Character.valueOf('\uff78'), Character.valueOf('\u30af'));
        WIDTH_MAP.put(Character.valueOf('\uff79'), Character.valueOf('\u30b1'));
        WIDTH_MAP.put(Character.valueOf('\uff7a'), Character.valueOf('\u30b3'));
        WIDTH_MAP.put(Character.valueOf('\uff7b'), Character.valueOf('\u30b5'));
        WIDTH_MAP.put(Character.valueOf('\uff7c'), Character.valueOf('\u30b7'));
        WIDTH_MAP.put(Character.valueOf('\uff7d'), Character.valueOf('\u30b9'));
        WIDTH_MAP.put(Character.valueOf('\uff7e'), Character.valueOf('\u30bb'));
        WIDTH_MAP.put(Character.valueOf('\uff7f'), Character.valueOf('\u30bd'));
        WIDTH_MAP.put(Character.valueOf('\uff80'), Character.valueOf('\u30bf'));
        WIDTH_MAP.put(Character.valueOf('\uff81'), Character.valueOf('\u30c1'));
        WIDTH_MAP.put(Character.valueOf('\uff82'), Character.valueOf('\u30c4'));
        WIDTH_MAP.put(Character.valueOf('\uff83'), Character.valueOf('\u30c6'));
        WIDTH_MAP.put(Character.valueOf('\uff84'), Character.valueOf('\u30c8'));
        WIDTH_MAP.put(Character.valueOf('\uff85'), Character.valueOf('\u30ca'));
        WIDTH_MAP.put(Character.valueOf('\uff86'), Character.valueOf('\u30cb'));
        WIDTH_MAP.put(Character.valueOf('\uff87'), Character.valueOf('\u30cc'));
        WIDTH_MAP.put(Character.valueOf('\uff88'), Character.valueOf('\u30cd'));
        WIDTH_MAP.put(Character.valueOf('\uff89'), Character.valueOf('\u30ce'));
        WIDTH_MAP.put(Character.valueOf('\uff8a'), Character.valueOf('\u30cf'));
        WIDTH_MAP.put(Character.valueOf('\uff8b'), Character.valueOf('\u30d2'));
        WIDTH_MAP.put(Character.valueOf('\uff8c'), Character.valueOf('\u30d5'));
        WIDTH_MAP.put(Character.valueOf('\uff8d'), Character.valueOf('\u30d8'));
        WIDTH_MAP.put(Character.valueOf('\uff8e'), Character.valueOf('\u30db'));
        WIDTH_MAP.put(Character.valueOf('\uff8f'), Character.valueOf('\u30de'));
        WIDTH_MAP.put(Character.valueOf('\uff90'), Character.valueOf('\u30df'));
        WIDTH_MAP.put(Character.valueOf('\uff91'), Character.valueOf('\u30e0'));
        WIDTH_MAP.put(Character.valueOf('\uff92'), Character.valueOf('\u30e1'));
        WIDTH_MAP.put(Character.valueOf('\uff93'), Character.valueOf('\u30e2'));
        WIDTH_MAP.put(Character.valueOf('\uff94'), Character.valueOf('\u30e4'));
        WIDTH_MAP.put(Character.valueOf('\uff95'), Character.valueOf('\u30e6'));
        WIDTH_MAP.put(Character.valueOf('\uff96'), Character.valueOf('\u30e8'));
        WIDTH_MAP.put(Character.valueOf('\uff97'), Character.valueOf('\u30e9'));
        WIDTH_MAP.put(Character.valueOf('\uff98'), Character.valueOf('\u30ea'));
        WIDTH_MAP.put(Character.valueOf('\uff99'), Character.valueOf('\u30eb'));
        WIDTH_MAP.put(Character.valueOf('\uff9a'), Character.valueOf('\u30ec'));
        WIDTH_MAP.put(Character.valueOf('\uff9b'), Character.valueOf('\u30ed'));
        WIDTH_MAP.put(Character.valueOf('\uff9c'), Character.valueOf('\u30ef'));
        WIDTH_MAP.put(Character.valueOf('\uff9d'), Character.valueOf('\u30f3'));
        WIDTH_MAP.put(Character.valueOf('\uff9e'), Character.valueOf('\u3099'));
        WIDTH_MAP.put(Character.valueOf('\uff9f'), Character.valueOf('\u309a'));
        WIDTH_MAP.put(Character.valueOf('\uffa0'), Character.valueOf('\u3164'));
        for (c = '\uffa1'; c <= '\uffbe'; c = (char)(c + '\u0001')) {
            mapping = (char)(c - 52848);
            WIDTH_MAP.put(Character.valueOf(c), Character.valueOf(mapping));
        }
        for (c = '\uffc2'; c <= '\uffc7'; c = (char)(c + '\u0001')) {
            mapping = (char)(c - 52851);
            WIDTH_MAP.put(Character.valueOf(c), Character.valueOf(mapping));
        }
        for (c = '\uffca'; c <= '\uffcf'; c = (char)(c + '\u0001')) {
            mapping = (char)(c - 52853);
            WIDTH_MAP.put(Character.valueOf(c), Character.valueOf(mapping));
        }
        for (c = '\uffd2'; c <= '\uffd7'; c = (char)(c + '\u0001')) {
            mapping = (char)(c - 52855);
            WIDTH_MAP.put(Character.valueOf(c), Character.valueOf(mapping));
        }
        WIDTH_MAP.put(Character.valueOf('\uffda'), Character.valueOf('\u3161'));
        WIDTH_MAP.put(Character.valueOf('\uffdb'), Character.valueOf('\u3162'));
        WIDTH_MAP.put(Character.valueOf('\uffdc'), Character.valueOf('\u3163'));
        WIDTH_MAP.put(Character.valueOf('\uffe0'), Character.valueOf('\u00a2'));
        WIDTH_MAP.put(Character.valueOf('\uffe1'), Character.valueOf('\u00a3'));
        WIDTH_MAP.put(Character.valueOf('\uffe2'), Character.valueOf('\u00ac'));
        WIDTH_MAP.put(Character.valueOf('\uffe3'), Character.valueOf('\u00af'));
        WIDTH_MAP.put(Character.valueOf('\uffe4'), Character.valueOf('\u00a6'));
        WIDTH_MAP.put(Character.valueOf('\uffe5'), Character.valueOf('\u00a5'));
        WIDTH_MAP.put(Character.valueOf('\uffe6'), Character.valueOf('\u20a9'));
        WIDTH_MAP.put(Character.valueOf('\uffe8'), Character.valueOf('\u2502'));
        WIDTH_MAP.put(Character.valueOf('\uffe9'), Character.valueOf('\u2190'));
        WIDTH_MAP.put(Character.valueOf('\uffea'), Character.valueOf('\u2191'));
        WIDTH_MAP.put(Character.valueOf('\uffeb'), Character.valueOf('\u2192'));
        WIDTH_MAP.put(Character.valueOf('\uffec'), Character.valueOf('\u2193'));
        WIDTH_MAP.put(Character.valueOf('\uffed'), Character.valueOf('\u25a0'));
        WIDTH_MAP.put(Character.valueOf('\uffee'), Character.valueOf('\u25cb'));
    }
}

