/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import java.text.Normalizer;
import rocks.xmpp.precis.PrecisProfile;

final class NicknameProfile
extends PrecisProfile {
    NicknameProfile() {
        super(false);
    }

    @Override
    public final String enforce(CharSequence input) {
        String enforced = this.applyDirectionalityRule(this.applyNormalizationRule(this.applyAdditionalMappingRule(this.prepare(input)))).toString();
        if (enforced.isEmpty()) {
            throw new IllegalArgumentException("Nickname must not be empty after applying the rules.");
        }
        return enforced;
    }

    @Override
    public final int compare(CharSequence o1, CharSequence o2) {
        return this.applyRulesForComparison(o1).compareTo(this.applyRulesForComparison(o2));
    }

    private String applyRulesForComparison(CharSequence input) {
        return this.applyDirectionalityRule(this.applyNormalizationRule(this.applyCaseMappingRule(this.applyAdditionalMappingRule(this.prepare(input))))).toString();
    }

    @Override
    protected final CharSequence applyWidthMappingRule(CharSequence input) {
        return input;
    }

    @Override
    protected final CharSequence applyAdditionalMappingRule(CharSequence input) {
        String mapped = WHITESPACE.matcher(input).replaceAll(" ");
        String trimmed = mapped.trim();
        return trimmed.replaceAll("[ ]+", " ");
    }

    @Override
    protected final CharSequence applyCaseMappingRule(CharSequence input) {
        return NicknameProfile.caseFold(input);
    }

    @Override
    protected final CharSequence applyNormalizationRule(CharSequence input) {
        return Normalizer.normalize(input, Normalizer.Form.NFKC);
    }

    @Override
    protected final CharSequence applyDirectionalityRule(CharSequence input) {
        return input;
    }
}

