/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.JedisMetaInfo;
import redis.clients.jedis.exceptions.JedisValidationException;

public final class DriverInfo {
    private static final Set<Character> BRACES = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'))));
    private final String name;
    private final List<String> upstreamDrivers;

    private DriverInfo(String name, List<String> upstreamDrivers) {
        this.name = name;
        this.upstreamDrivers = Collections.unmodifiableList(upstreamDrivers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DriverInfo driverInfo) {
        if (driverInfo == null) {
            throw new JedisValidationException("DriverInfo must not be null");
        }
        return new Builder(driverInfo);
    }

    public String getFormattedName() {
        if (this.upstreamDrivers.isEmpty()) {
            return this.name;
        }
        return String.format("%s(%s)", this.name, String.join((CharSequence)";", this.upstreamDrivers));
    }

    public String getName() {
        return this.name;
    }

    public String getUpstreamDrivers() {
        if (this.upstreamDrivers.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)";", this.upstreamDrivers);
    }

    public String toString() {
        return this.getFormattedName();
    }

    private static void validateDriverField(String value, String fieldName) {
        if (value.trim().isEmpty()) {
            throw new JedisValidationException(fieldName + " must not be empty");
        }
        DriverInfo.validateNoInvalidCharacters(value, fieldName);
    }

    private static void validateNoInvalidCharacters(String value, String fieldName) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '!' && c <= '~' && !BRACES.contains(Character.valueOf(c))) continue;
            throw new JedisValidationException(fieldName + " must not contain spaces, newlines, non-printable characters, or braces");
        }
    }

    private static String formatDriverInfo(String driverName, String driverVersion) {
        return driverName + "_v" + driverVersion;
    }

    public static class Builder {
        private String name;
        private final List<String> upstreamDrivers;

        private Builder() {
            this.name = JedisMetaInfo.getArtifactId();
            this.upstreamDrivers = new ArrayList<String>();
        }

        private Builder(DriverInfo driverInfo) {
            this.name = driverInfo.name;
            this.upstreamDrivers = new ArrayList<String>(driverInfo.upstreamDrivers);
        }

        public Builder name(String name) {
            if (name == null) {
                throw new JedisValidationException("Name must not be null");
            }
            this.name = name;
            return this;
        }

        public Builder addUpstreamDriver(String driverName, String driverVersion) {
            if (driverName == null) {
                throw new JedisValidationException("Driver name must not be null");
            }
            if (driverVersion == null) {
                throw new JedisValidationException("Driver version must not be null");
            }
            DriverInfo.validateDriverField(driverName, "Driver name");
            DriverInfo.validateDriverField(driverVersion, "Driver version");
            String formattedDriverInfo = DriverInfo.formatDriverInfo(driverName, driverVersion);
            this.upstreamDrivers.add(0, formattedDriverInfo);
            return this;
        }

        public Builder addUpstreamDriver(String driverName) {
            if (driverName == null) {
                throw new JedisValidationException("Driver name must not be null");
            }
            DriverInfo.validateDriverField(driverName, "Driver name");
            this.upstreamDrivers.add(0, driverName);
            return this;
        }

        public DriverInfo build() {
            return new DriverInfo(this.name, this.upstreamDrivers);
        }
    }
}

