/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.timeseries.DuplicatePolicy;
import redis.clients.jedis.timeseries.TimeSeriesProtocol;

public class TSAlterParams
implements IParams {
    private Long retentionPeriod;
    private Long chunkSize;
    private DuplicatePolicy duplicatePolicy;
    private boolean ignore;
    private long ignoreMaxTimediff;
    private double ignoreMaxValDiff;
    private Map<String, String> labels;

    public static TSAlterParams alterParams() {
        return new TSAlterParams();
    }

    public TSAlterParams retention(long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    public TSAlterParams chunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public TSAlterParams duplicatePolicy(DuplicatePolicy duplicatePolicy) {
        this.duplicatePolicy = duplicatePolicy;
        return this;
    }

    public TSAlterParams ignore(long maxTimediff, double maxValDiff) {
        this.ignore = true;
        this.ignoreMaxTimediff = maxTimediff;
        this.ignoreMaxValDiff = maxValDiff;
        return this;
    }

    public TSAlterParams labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public TSAlterParams label(String label, String value) {
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        this.labels.put(label, value);
        return this;
    }

    public TSAlterParams labelsReset() {
        return this.labels(Collections.emptyMap());
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.retentionPeriod != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.RETENTION).add(Protocol.toByteArray(this.retentionPeriod));
        }
        if (this.chunkSize != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.CHUNK_SIZE).add(Protocol.toByteArray(this.chunkSize));
        }
        if (this.duplicatePolicy != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.DUPLICATE_POLICY).add(this.duplicatePolicy);
        }
        if (this.ignore) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.IGNORE).add(this.ignoreMaxTimediff).add(this.ignoreMaxValDiff);
        }
        if (this.labels != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.LABELS);
            this.labels.entrySet().forEach(entry -> args.add((String)entry.getKey()).add((String)entry.getValue()));
        }
    }
}

